/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.util.concurrent.atomic.AtomicLong;

public class SimpleCounterStatistic {
    private final String name;
    private final int align;
    private final AlignGroup group;
    private final AtomicLong currentCounter = new AtomicLong();
    private final AtomicLong overallCounter = new AtomicLong();
    private final AtomicLong startCounter = new AtomicLong(-1L);

    public SimpleCounterStatistic(String name) {
        this.name = name;
        this.align = 0;
        this.group = null;
    }

    public SimpleCounterStatistic(String name, int align) {
        this.name = name;
        this.align = align;
        this.group = null;
    }

    public SimpleCounterStatistic(String name, AlignGroup group) {
        this.name = name;
        this.align = 0;
        this.group = group.add(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferCounter() {
        AtomicLong atomicLong = this.overallCounter;
        synchronized (atomicLong) {
            long current = this.currentCounter.getAndSet(0L);
            this.overallCounter.addAndGet(current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dump(int align) {
        long overall;
        long current;
        AtomicLong atomicLong = this.overallCounter;
        synchronized (atomicLong) {
            current = this.currentCounter.get();
            overall = this.overallCounter.get();
        }
        return SimpleCounterStatistic.format(align, this.name, current) + String.format(" (%8d overall).", overall);
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStart(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("Value " + value + " must not be less than 0!");
        }
        AtomicLong atomicLong = this.overallCounter;
        synchronized (atomicLong) {
            this.startCounter.set(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(long value) {
        AtomicLong atomicLong = this.overallCounter;
        synchronized (atomicLong) {
            long start = this.startCounter.get();
            if (start < 0L) {
                start = 0L;
                this.startCounter.set(0L);
            }
            this.currentCounter.set(value - this.overallCounter.get() - start);
        }
    }

    public long increment() {
        return this.currentCounter.incrementAndGet();
    }

    public long increment(int delta) {
        return this.currentCounter.addAndGet(delta);
    }

    public long decrement() {
        return this.currentCounter.decrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCounter() {
        AtomicLong atomicLong = this.overallCounter;
        synchronized (atomicLong) {
            return this.overallCounter.get() + this.currentCounter.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getCountersPair() {
        AtomicLong atomicLong = this.overallCounter;
        synchronized (atomicLong) {
            return new long[]{this.currentCounter.get(), this.overallCounter.get()};
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long reset() {
        AtomicLong atomicLong = this.overallCounter;
        synchronized (atomicLong) {
            long current = this.currentCounter.getAndSet(0L);
            this.overallCounter.addAndGet(current);
            current = this.overallCounter.getAndSet(0L);
            long start = this.startCounter.get();
            if (start > 0L) {
                this.startCounter.set(current + start);
            } else {
                this.startCounter.set(current);
            }
            return current;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUsed() {
        AtomicLong atomicLong = this.overallCounter;
        synchronized (atomicLong) {
            return this.currentCounter.get() > 0L || this.overallCounter.get() > 0L;
        }
    }

    public boolean isStarted() {
        return this.startCounter.get() >= 0L;
    }

    public String toString() {
        int align = this.group == null ? this.align : this.group.getAlign();
        return this.dump(align);
    }

    public static String format(int align, String name, long value) {
        if (align == 0) {
            return String.format("%s: %8d", name, value);
        }
        return String.format("%" + align + "s: %8d", name, value);
    }

    public static class AlignGroup {
        int align;

        public AlignGroup add(SimpleCounterStatistic statistic) {
            return this.add(statistic.getName());
        }

        public AlignGroup add(String name) {
            int align = name.length();
            if (align > this.align) {
                this.align = align;
            }
            return this;
        }

        public int getAlign() {
            return -(this.align + 1);
        }
    }
}

