/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.interceptors;

import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.interceptors.MalformedMessageInterceptor;
import org.eclipse.californium.elements.RawData;
import org.eclipse.californium.elements.util.CounterStatisticManager;
import org.eclipse.californium.elements.util.SimpleCounterStatistic;
import org.eclipse.californium.elements.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthStatisticLogger
extends CounterStatisticManager
implements MalformedMessageInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(HealthStatisticLogger.class);
    private final SimpleCounterStatistic sentRequests;
    private final SimpleCounterStatistic sentResponses;
    private final SimpleCounterStatistic sentRejects;
    private final SimpleCounterStatistic sentAcknowledges;
    private final SimpleCounterStatistic resentRequests;
    private final SimpleCounterStatistic resentResponses;
    private final SimpleCounterStatistic sendErrors;
    private final SimpleCounterStatistic receivedRequests;
    private final SimpleCounterStatistic receivedResponses;
    private final SimpleCounterStatistic receivedRejects;
    private final SimpleCounterStatistic receivedAcknowledges;
    private final SimpleCounterStatistic duplicateRequests;
    private final SimpleCounterStatistic duplicateResponses;
    private final SimpleCounterStatistic ignoredMessages;
    private final SimpleCounterStatistic malformedMessages;
    private final SimpleCounterStatistic offloadedMessages;
    private final boolean udp;
    private volatile boolean used;

    public HealthStatisticLogger(String tag, boolean udp) {
        super(tag);
        this.sentRequests = new SimpleCounterStatistic("requests", this.align);
        this.sentResponses = new SimpleCounterStatistic("responses", this.align);
        this.sentRejects = new SimpleCounterStatistic("rejects", this.align);
        this.sentAcknowledges = new SimpleCounterStatistic("acks", this.align);
        this.resentRequests = new SimpleCounterStatistic("request retransmissions", this.align);
        this.resentResponses = new SimpleCounterStatistic("response retransmissions", this.align);
        this.sendErrors = new SimpleCounterStatistic("errors", this.align);
        this.receivedRequests = new SimpleCounterStatistic("requests", this.align);
        this.receivedResponses = new SimpleCounterStatistic("responses", this.align);
        this.receivedRejects = new SimpleCounterStatistic("rejects", this.align);
        this.receivedAcknowledges = new SimpleCounterStatistic("acks", this.align);
        this.duplicateRequests = new SimpleCounterStatistic("duplicate requests", this.align);
        this.duplicateResponses = new SimpleCounterStatistic("duplicate responses", this.align);
        this.ignoredMessages = new SimpleCounterStatistic("ignored", this.align);
        this.malformedMessages = new SimpleCounterStatistic("malformed", this.align);
        this.offloadedMessages = new SimpleCounterStatistic("offloaded", this.align);
        this.udp = udp;
        this.init();
    }

    private void init() {
        this.add("send-", this.sentRequests);
        this.add("send-", this.sentResponses);
        if (this.udp) {
            this.add("send-", this.sentAcknowledges);
            this.add("send-", this.sentRejects);
            this.add("send-", this.resentRequests);
            this.add("send-", this.resentResponses);
        }
        this.add("send-", this.sendErrors);
        this.add("recv-", this.receivedRequests);
        this.add("recv-", this.receivedResponses);
        if (this.udp) {
            this.add("recv-", this.receivedAcknowledges);
            this.add("recv-", this.receivedRejects);
            this.add("recv-", this.duplicateRequests);
            this.add("recv-", this.duplicateResponses);
            this.add("recv-", this.offloadedMessages);
        }
        this.add("recv-", this.ignoredMessages);
        this.add("recv-", this.malformedMessages);
    }

    @Override
    public boolean isEnabled() {
        return LOGGER.isInfoEnabled();
    }

    @Override
    public void dump() {
        try {
            if (this.isEnabled()) {
                if (LOGGER.isDebugEnabled() && this.used) {
                    String eol = StringUtil.lineSeparator();
                    String head = "   " + this.tag;
                    StringBuilder log = new StringBuilder();
                    log.append(this.tag).append("endpoint statistic:").append(eol);
                    log.append(this.tag).append("send statistic:").append(eol);
                    log.append(head).append(this.sentRequests).append(eol);
                    log.append(head).append(this.sentResponses).append(eol);
                    if (this.udp) {
                        log.append(head).append(this.sentAcknowledges).append(eol);
                        log.append(head).append(this.sentRejects).append(eol);
                        log.append(head).append(this.resentRequests).append(eol);
                        log.append(head).append(this.resentResponses).append(eol);
                    }
                    log.append(head).append(this.sendErrors).append(eol);
                    log.append(this.tag).append("receive statistic:").append(eol);
                    log.append(head).append(this.receivedRequests).append(eol);
                    log.append(head).append(this.receivedResponses).append(eol);
                    if (this.udp) {
                        log.append(head).append(this.receivedAcknowledges).append(eol);
                        log.append(head).append(this.receivedRejects).append(eol);
                        log.append(head).append(this.duplicateRequests).append(eol);
                        log.append(head).append(this.duplicateResponses).append(eol);
                        log.append(head).append(this.offloadedMessages).append(eol);
                    }
                    log.append(head).append(this.ignoredMessages).append(eol);
                    long sent = this.getSentCounters();
                    long processed = this.getProcessedCounters();
                    log.append(this.tag).append("sent ").append(sent).append(", received ").append(processed);
                    LOGGER.debug("{}", (Object)log);
                }
                this.transferCounter();
            }
        }
        catch (Throwable e) {
            LOGGER.error("{}", (Object)this.tag, (Object)e);
        }
    }

    public long getSentCounters() {
        long sent = this.sentRequests.getCounter() + this.sentResponses.getCounter() + this.sentAcknowledges.getCounter() + this.sentRejects.getCounter() + this.resentRequests.getCounter() + this.resentResponses.getCounter();
        return sent;
    }

    public long getProcessedCounters() {
        long processed = this.receivedRequests.getCounter() + this.receivedResponses.getCounter() + this.receivedAcknowledges.getCounter() + this.receivedRejects.getCounter() + this.duplicateRequests.getCounter() + this.duplicateResponses.getCounter() + this.ignoredMessages.getCounter();
        return processed;
    }

    @Override
    public void sendRequest(Request request) {
        this.used = true;
        if (request.getSendError() != null) {
            this.sendErrors.increment();
        } else if (request.isDuplicate()) {
            this.resentRequests.increment();
        } else {
            this.sentRequests.increment();
        }
    }

    @Override
    public void sendResponse(Response response) {
        this.used = true;
        if (response.getOffloadMode() != null) {
            this.offloadedMessages.increment();
        }
        if (response.getSendError() != null) {
            this.sendErrors.increment();
        } else if (response.isDuplicate()) {
            this.resentResponses.increment();
        } else {
            this.sentResponses.increment();
        }
    }

    @Override
    public void sendEmptyMessage(EmptyMessage message) {
        this.used = true;
        if (message.getSendError() != null) {
            this.sendErrors.increment();
        } else if (message.getType() == CoAP.Type.ACK) {
            this.sentAcknowledges.increment();
        } else {
            this.sentRejects.increment();
        }
    }

    @Override
    public void receiveRequest(Request request) {
        this.used = true;
        if (request.isDuplicate()) {
            this.duplicateRequests.increment();
        } else {
            this.receivedRequests.increment();
        }
    }

    @Override
    public void receiveResponse(Response response) {
        this.used = true;
        if (response.isCanceled()) {
            this.ignoredMessages.increment();
        } else if (response.isDuplicate()) {
            this.duplicateResponses.increment();
        } else {
            this.receivedResponses.increment();
        }
    }

    @Override
    public void receiveEmptyMessage(EmptyMessage message) {
        this.used = true;
        if (message.isCanceled()) {
            this.ignoredMessages.increment();
        } else if (message.getType() == CoAP.Type.ACK) {
            this.receivedAcknowledges.increment();
        } else {
            this.receivedRejects.increment();
        }
    }

    @Override
    public void receivedMalformedMessage(RawData message) {
        this.used = true;
        this.malformedMessages.increment();
    }
}

