/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap;

import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.option.BlockOption;
import org.eclipse.californium.elements.EndpointContext;

public class EmptyMessage
extends Message {
    public EmptyMessage(CoAP.Type type) {
        super(type);
        this.setProtectFromOffload();
    }

    public String toString() {
        String appendix = "";
        if (!this.hasEmptyToken() || this.getOptions().asSortedList().size() > 0 || this.getPayloadSize() > 0) {
            String payload = this.getPayloadString();
            if (payload == null) {
                payload = "no payload";
            } else {
                int len = payload.length();
                if (payload.indexOf("\n") != -1) {
                    payload = payload.substring(0, payload.indexOf("\n"));
                }
                if (payload.length() > 24) {
                    payload = payload.substring(0, 20);
                }
                if ((payload = "\"" + payload + "\"").length() != len + 2) {
                    payload = payload + ".. " + payload.length() + " bytes";
                }
            }
            appendix = " NON-EMPTY: Token=" + this.getTokenString() + ", " + this.getOptions() + ", " + payload;
        }
        return String.format("%s        MID=%5d%s", new Object[]{this.getType(), this.getMID(), appendix});
    }

    @Override
    public int getRawCode() {
        return 0;
    }

    @Override
    public boolean isIntendedPayload() {
        return false;
    }

    @Override
    public void assertPayloadMatchsBlocksize() {
        if (this.getPayloadSize() > 0) {
            throw new IllegalStateException("Empty message contains " + this.getPayloadSize() + " bytes payload!");
        }
    }

    @Override
    public boolean hasBlock(BlockOption block) {
        return false;
    }

    public static EmptyMessage newACK(Message message) {
        return EmptyMessage.newACK(message, message.getSourceContext());
    }

    public static EmptyMessage newACK(Message message, EndpointContext destination) {
        EmptyMessage ack = new EmptyMessage(CoAP.Type.ACK);
        ack.setDestinationContext(destination);
        ack.setMID(message.getMID());
        return ack;
    }

    public static EmptyMessage newRST(Message message) {
        return EmptyMessage.newRST(message, message.getSourceContext());
    }

    public static EmptyMessage newRST(Message message, EndpointContext destination) {
        EmptyMessage rst = new EmptyMessage(CoAP.Type.RST);
        rst.setDestinationContext(destination);
        rst.setMID(message.getMID());
        return rst;
    }
}

