/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.oscore;

import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.OptionSet;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;

public class OSCoreResource
extends CoapResource {
    private final boolean isProtected;

    public OSCoreResource(String name, boolean isProtected) {
        super(name);
        this.isProtected = isProtected;
    }

    @Override
    public void handleRequest(Exchange exchange) {
        OptionSet options;
        if (this.isProtected && !(options = exchange.getRequest().getOptions()).hasOscore()) {
            Response r = new Response(CoAP.ResponseCode.UNAUTHORIZED);
            r.setType(CoAP.Type.RST);
            exchange.sendResponse(r);
            return;
        }
        exchange.getRequest().getOptions().removeOscore();
        super.handleRequest(exchange);
    }

    public boolean isProtected() {
        return this.isProtected;
    }
}

