/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.oscore;

import com.upokecenter.cbor.CBORException;
import com.upokecenter.cbor.CBORObject;
import java.security.SecureRandom;
import java.util.Arrays;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.cose.CoseException;
import org.eclipse.californium.elements.exception.ConnectorException;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.oscore.CoapOSException;
import org.eclipse.californium.oscore.OSCoreCtx;
import org.eclipse.californium.oscore.OSCoreCtxDB;
import org.eclipse.californium.oscore.OSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextRederivation {
    private static SecureRandom random = new SecureRandom();
    private static final String SCHEME = "coap://";
    protected static int SEGMENT_LENGTH = 8;
    private static final Logger LOGGER = LoggerFactory.getLogger(ContextRederivation.class);

    public static void setLostContext(OSCoreCtxDB db, String uri) throws CoapOSException {
        try {
            ContextRederivation.initiateRequest(db, uri);
        }
        catch (ConnectorException | OSException e) {
            LOGGER.error("Security context re-generation failed");
            throw new CoapOSException("Security context re-generation failed", CoAP.ResponseCode.BAD_REQUEST);
        }
    }

    private static void initiateRequest(OSCoreCtxDB db, String uri) throws ConnectorException, OSException {
        OSCoreCtx ctx = db.getContext(uri);
        if (!ctx.getContextRederivationEnabled()) {
            LOGGER.error("Context re-derivation is not enabled for this context.");
            throw new IllegalStateException("Context re-derivation is not enabled for this context.");
        }
        ContextRederivation.printStateLogging(ctx);
        byte[] contextID1 = Bytes.createBytes(random, SEGMENT_LENGTH);
        OSCoreCtx newCtx = ContextRederivation.rederiveWithContextID(ctx, contextID1);
        newCtx.setIncludeContextId(ContextRederivation.encodeToCborBstrBytes(contextID1));
        newCtx.setContextRederivationPhase(PHASE.CLIENT_PHASE_1);
        db.removeContext(ctx);
        db.addContext(uri, newCtx);
    }

    static OSCoreCtx incomingResponse(OSCoreCtxDB db, OSCoreCtx ctx, byte[] contextID) throws OSException {
        if (!ctx.getContextRederivationEnabled()) {
            LOGGER.debug("Context re-derivation not considered due to it being disabled for this context");
            return ctx;
        }
        if (ctx.getContextRederivationPhase() == PHASE.CLIENT_PHASE_3) {
            ContextRederivation.printStateLogging(ctx);
            ctx.setIncludeContextId(false);
            ctx.setContextRederivationPhase(PHASE.INACTIVE);
            return ctx;
        }
        if (ctx.getContextRederivationPhase() == PHASE.CLIENT_PHASE_1) {
            ContextRederivation.printStateLogging(ctx);
            byte[] contextR2 = ContextRederivation.decodeFromCborBstrBytes(contextID);
            byte[] contextID1 = ctx.getIdContext();
            byte[] verifyContextID = Bytes.concatenate(contextR2, contextID1);
            OSCoreCtx newCtx = ContextRederivation.rederiveWithContextID(ctx, verifyContextID);
            newCtx.setContextRederivationPhase(PHASE.CLIENT_PHASE_2);
            db.removeContext(ctx);
            db.addContext(SCHEME + ctx.getUri(), newCtx);
            return newCtx;
        }
        if (ctx.getContextRederivationPhase() == PHASE.INACTIVE) {
            ContextRederivation.printStateLogging(ctx);
            if (contextID == null || Arrays.equals(ctx.getIdContext(), contextID)) {
                return ctx;
            }
            byte[] contextR2 = ContextRederivation.decodeFromCborBstrBytes(contextID);
            byte[] contextID1 = ctx.getIdContext();
            byte[] verifyContextID = Bytes.concatenate(contextR2, contextID1);
            OSCoreCtx newCtx = ContextRederivation.rederiveWithContextID(ctx, verifyContextID);
            newCtx.setContextRederivationPhase(PHASE.CLIENT_PHASE_2);
            db.removeContext(ctx);
            db.addContext(SCHEME + ctx.getUri(), newCtx);
            return newCtx;
        }
        return ctx;
    }

    static OSCoreCtx outgoingRequest(OSCoreCtxDB db, OSCoreCtx ctx) throws OSException {
        if (ctx.getContextRederivationPhase() == PHASE.CLIENT_PHASE_2) {
            ContextRederivation.printStateLogging(ctx);
            byte[] currentContextID = ctx.getIdContext();
            byte[] contextR2 = Arrays.copyOfRange(currentContextID, 0, currentContextID.length - SEGMENT_LENGTH);
            byte[] contextR3 = Bytes.createBytes(random, SEGMENT_LENGTH);
            byte[] protectContextID = Bytes.concatenate(contextR2, contextR3);
            OSCoreCtx newCtx = ContextRederivation.rederiveWithContextID(ctx, protectContextID);
            newCtx.setIncludeContextId(ContextRederivation.encodeToCborBstrBytes(protectContextID));
            newCtx.setContextRederivationPhase(PHASE.CLIENT_PHASE_3);
            db.removeContext(ctx);
            db.addContext(SCHEME + ctx.getUri(), newCtx);
            return newCtx;
        }
        return ctx;
    }

    static OSCoreCtx incomingRequest(OSCoreCtxDB db, OSCoreCtx ctx, byte[] contextID, byte[] rid) throws OSException {
        if (ctx == null) {
            ctx = db.getContext(rid);
        }
        if (ctx == null) {
            return null;
        }
        if (!ctx.getContextRederivationEnabled()) {
            LOGGER.debug("Context re-derivation not considered due to it being disabled for this context");
            return ctx;
        }
        if (ctx.getContextRederivationPhase() == PHASE.SERVER_PHASE_2) {
            ContextRederivation.printStateLogging(ctx);
            byte[] contextS2 = Arrays.copyOfRange(ctx.getIdContext(), 0, SEGMENT_LENGTH);
            byte[] hmacOutput = ContextRederivation.performHMAC(ctx.getContextRederivationKey(), contextS2);
            byte[] messageHmacOutput = Arrays.copyOfRange(ctx.getIdContext(), SEGMENT_LENGTH, SEGMENT_LENGTH * 2);
            if (!Arrays.equals(hmacOutput, messageHmacOutput)) {
                throw new OSException("Security context re-generation failed");
            }
            byte[] contextIdParsed = ContextRederivation.decodeFromCborBstrBytes(contextID);
            OSCoreCtx newCtx = ContextRederivation.rederiveWithContextID(ctx, contextIdParsed);
            newCtx.setContextRederivationPhase(PHASE.SERVER_PHASE_3);
            db.removeContext(ctx);
            db.addContext(newCtx);
            return newCtx;
        }
        if (ctx.getContextRederivationPhase() == PHASE.INACTIVE) {
            ContextRederivation.printStateLogging(ctx);
            if (contextID == null || Arrays.equals(contextID, ctx.getIdContext())) {
                return ctx;
            }
            byte[] contextID1 = null;
            try {
                contextID1 = ContextRederivation.decodeFromCborBstrBytes(contextID);
            }
            catch (CBORException e) {
                LOGGER.debug("Client initiated context re-derivation not started as ID Context in request is not a CBOR byte string.");
                return ctx;
            }
            OSCoreCtx newCtx = ContextRederivation.rederiveWithContextID(ctx, contextID1);
            newCtx.setContextRederivationPhase(PHASE.SERVER_PHASE_1);
            db.removeContext(ctx);
            db.addContext(newCtx);
            return newCtx;
        }
        if (ctx.getContextRederivationPhase() == PHASE.SERVER_INITIATE) {
            ContextRederivation.printStateLogging(ctx);
            byte[] contextID1 = ctx.getIdContext();
            OSCoreCtx newCtx = ContextRederivation.rederiveWithContextID(ctx, contextID1);
            newCtx.setContextRederivationPhase(PHASE.SERVER_PHASE_1);
            db.removeContext(ctx);
            db.addContext(newCtx);
            return newCtx;
        }
        return ctx;
    }

    static OSCoreCtx outgoingResponse(OSCoreCtxDB db, OSCoreCtx ctx) throws OSException {
        if (ctx.getContextRederivationPhase() == PHASE.SERVER_PHASE_3) {
            ContextRederivation.printStateLogging(ctx);
            ctx.setIncludeContextId(false);
            ctx.setContextRederivationPhase(PHASE.INACTIVE);
            return ctx;
        }
        if (ctx.getContextRederivationPhase() == PHASE.SERVER_PHASE_1) {
            ContextRederivation.printStateLogging(ctx);
            int keyLength = ctx.getSenderKey().length;
            byte[] contextRederivationKey = Bytes.createBytes(random, keyLength);
            ctx.setContextRederivationKey(contextRederivationKey);
            byte[] contextID1 = ctx.getIdContext();
            byte[] contextS2 = Bytes.createBytes(random, SEGMENT_LENGTH);
            byte[] hmacOutput = ContextRederivation.performHMAC(ctx.getContextRederivationKey(), contextS2);
            byte[] contextR2 = Bytes.concatenate(contextS2, hmacOutput);
            byte[] protectContextID = Bytes.concatenate(contextR2, contextID1);
            OSCoreCtx newCtx = ContextRederivation.rederiveWithContextID(ctx, protectContextID);
            newCtx.setIncludeContextId(ContextRederivation.encodeToCborBstrBytes(contextR2));
            newCtx.setResponsesIncludePartialIV(true);
            newCtx.setContextRederivationPhase(PHASE.SERVER_PHASE_2);
            db.removeContext(ctx);
            db.addContext(newCtx);
            return newCtx;
        }
        return ctx;
    }

    private static OSCoreCtx rederiveWithContextID(OSCoreCtx ctx, byte[] contextID) throws OSException {
        OSCoreCtx newCtx = new OSCoreCtx(ctx.getMasterSecret(), true, ctx.getAlg(), ctx.getSenderId(), ctx.getRecipientId(), ctx.getKdf(), ctx.getRecipientReplaySize(), ctx.getSalt(), contextID, ctx.getMaxUnfragmentedSize());
        newCtx.setContextRederivationKey(ctx.getContextRederivationKey());
        newCtx.setContextRederivationEnabled(ctx.getContextRederivationEnabled());
        return newCtx;
    }

    private static byte[] performHMAC(byte[] contextRederivationKey, byte[] input) throws OSException {
        byte[] key = null;
        try {
            key = OSCoreCtx.deriveKey(contextRederivationKey, contextRederivationKey, SEGMENT_LENGTH, "SHA256", input);
        }
        catch (CoseException e) {
            throw new OSException("Security context re-generation failed");
        }
        return key;
    }

    private static byte[] encodeToCborBstrBytes(byte[] array) {
        CBORObject arrayBstr = CBORObject.FromObject(array);
        return arrayBstr.EncodeToBytes();
    }

    private static byte[] decodeFromCborBstrBytes(byte[] bstr) {
        CBORObject arrayBstr = CBORObject.DecodeFromBytes(bstr);
        return arrayBstr.GetByteString();
    }

    private static void printStateLogging(OSCoreCtx ctx) {
        if (!LOGGER.isDebugEnabled()) {
            return;
        }
        PHASE currentPhase = ctx.getContextRederivationPhase();
        String supplemental = "";
        switch (currentPhase) {
            case INACTIVE: {
                supplemental = "client/server context re-derivation inactive";
                break;
            }
            case CLIENT_INITIATE: {
                supplemental = "client will initiate context re-derivation";
                break;
            }
            case SERVER_INITIATE: {
                supplemental = "server will initiate context re-derivation";
                break;
            }
            case CLIENT_PHASE_1: {
                supplemental = "client has sent the first request in the procedure and is receving the response";
                break;
            }
            case CLIENT_PHASE_2: {
                supplemental = "client is sending the second request in the procedure";
                break;
            }
            case CLIENT_PHASE_3: {
                supplemental = "client has received the second response in the procedure and is concluding";
                break;
            }
            case SERVER_PHASE_1: {
                supplemental = "server has received the first request in the procedure and is sending the response";
                break;
            }
            case SERVER_PHASE_2: {
                supplemental = "server is receiving the second request in the procedure";
                break;
            }
            case SERVER_PHASE_3: {
                supplemental = "server has sent the second response in the procedure and is concluding";
                break;
            }
            default: {
                supplemental = "context re-derivation is in unknown state indicating a problem";
            }
        }
        if (currentPhase == PHASE.INACTIVE) {
            LOGGER.trace("Context re-derivation phase: {} ({})", (Object)currentPhase, (Object)supplemental);
        } else {
            LOGGER.debug("Context re-derivation phase: {} ({})", (Object)currentPhase, (Object)supplemental);
        }
    }

    public static enum PHASE {
        INACTIVE,
        CLIENT_INITIATE,
        SERVER_INITIATE,
        SERVER_PHASE_1,
        SERVER_PHASE_2,
        SERVER_PHASE_3,
        CLIENT_PHASE_1,
        CLIENT_PHASE_2,
        CLIENT_PHASE_3;

    }
}

