/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.regex.Pattern;
import org.eclipse.californium.core.WebLink;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.server.resources.Resource;
import org.eclipse.californium.core.server.resources.ResourceAttributes;
import org.eclipse.californium.elements.util.StringUtil;

public class LinkFormat {
    public static final String RESOURCE_TYPE = "rt";
    public static final String INTERFACE_DESCRIPTION = "if";
    public static final String CONTENT_TYPE = "ct";
    public static final String MAX_SIZE_ESTIMATE = "sz";
    public static final String TITLE = "title";
    public static final String OBSERVABLE = "obs";
    public static final String LINK = "href";
    public static final String LIFE_TIME = "lt";
    public static final String SECTOR = "d";
    public static final String CONTEXT = "anchor";
    public static final String BASE = "base";
    public static final String RELATION = "rel";
    public static final String END_POINT = "ep";
    public static final String END_POINT_TYPE = "et";
    public static final String COUNT = "count";
    public static final String PAGE = "page";
    public static final Pattern DELIMITER = Pattern.compile("\\s*,+\\s*");
    public static final Pattern TAG = Pattern.compile("<[^>]*>");
    public static final Pattern SEPARATOR = Pattern.compile("\\s*;+\\s*");
    public static final Pattern WORD = Pattern.compile("\\w+");
    public static final Pattern QUOTED_STRING = Pattern.compile("\\G\".*?\"");
    public static final Pattern CARDINAL = Pattern.compile("\\G\\d+");
    public static final Pattern EQUAL = Pattern.compile("=");
    public static final Pattern SPACE = Pattern.compile("\\s");
    public static final Pattern NUMBER = Pattern.compile("^\\d+$");

    public static List<Resource> sort(Collection<Resource> resources) {
        ArrayList<Resource> sortedResources = new ArrayList<Resource>(resources);
        Collections.sort(sortedResources, new Comparator<Resource>(){

            @Override
            public int compare(Resource o1, Resource o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return sortedResources;
    }

    public static Set<WebLink> getSubTree(Resource resource) {
        return LinkFormat.getSubTree(resource, null);
    }

    public static Set<WebLink> getSubTree(Resource resource, List<String> queries) {
        ConcurrentSkipListSet<WebLink> links = new ConcurrentSkipListSet<WebLink>();
        LinkFormat.addSubTree(resource, queries, links);
        return links;
    }

    public static void addSubTree(Resource resource, List<String> queries, Set<WebLink> links) {
        for (Resource child : LinkFormat.sort(resource.getChildren())) {
            LinkFormat.addTree(child, queries, links);
        }
    }

    public static Set<WebLink> getTree(Resource resource) {
        return LinkFormat.getTree(resource, null);
    }

    public static Set<WebLink> getTree(Resource resource, List<String> queries) {
        ConcurrentSkipListSet<WebLink> links = new ConcurrentSkipListSet<WebLink>();
        LinkFormat.addTree(resource, queries, links);
        return links;
    }

    public static void addTree(Resource resource, List<String> queries, Set<WebLink> links) {
        WebLink link;
        if (resource.isVisible() && LinkFormat.matches(link = LinkFormat.createWebLink(resource), queries)) {
            links.add(link);
        }
        LinkFormat.addSubTree(resource, queries, links);
    }

    public static String serialize(Set<WebLink> links) {
        StringBuilder builder = new StringBuilder();
        LinkFormat.serialize(links, builder);
        return builder.toString();
    }

    public static void serialize(Set<WebLink> links, StringBuilder builder) {
        for (WebLink link : links) {
            LinkFormat.serialize(link, builder);
            builder.append(',');
        }
        StringUtil.truncateTail(builder, ",");
    }

    public static String serialize(WebLink link) {
        StringBuilder builder = new StringBuilder();
        LinkFormat.serialize(link, builder);
        return builder.toString();
    }

    public static void serialize(WebLink link, StringBuilder builder) {
        builder.append("<").append(link.getURI()).append(">");
        LinkFormat.serializeAttributes(link.getAttributes(), builder);
    }

    public static String serializeTree(Resource resource) {
        return LinkFormat.serializeTree(resource, null);
    }

    public static String serializeTree(Resource resource, List<String> queries) {
        Set<WebLink> subTree = LinkFormat.getSubTree(resource, queries);
        return LinkFormat.serialize(subTree);
    }

    @Deprecated
    public static void serializeTree(Resource resource, List<String> queries, StringBuilder buffer) {
        Set<WebLink> subTree = LinkFormat.getSubTree(resource, queries);
        LinkFormat.serialize(subTree, buffer);
        buffer.append(',');
    }

    @Deprecated
    public static StringBuilder serializeResource(Resource resource) {
        WebLink webLink = LinkFormat.createWebLink(resource);
        StringBuilder builder = new StringBuilder();
        LinkFormat.serialize(webLink, builder);
        builder.append(",");
        return builder;
    }

    public static StringBuilder serializePath(Resource resource) {
        StringBuilder builder = new StringBuilder();
        LinkFormat.serializePath(resource, builder);
        StringUtil.truncateTail(builder, "/");
        return builder;
    }

    private static void serializePath(Resource resource, StringBuilder builder) {
        if (resource == null) {
            return;
        }
        LinkFormat.serializePath(resource.getParent(), builder);
        String path = LinkFormat.serializePathName(resource.getName());
        builder.append(path).append("/");
    }

    public static String serializePathName(String name) {
        try {
            return URLEncoder.encode(name, CoAP.UTF8_CHARSET.name());
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static StringBuilder serializeAttributes(ResourceAttributes attributes) {
        StringBuilder builder = new StringBuilder();
        LinkFormat.serializeAttributes(attributes, builder);
        return builder;
    }

    public static void serializeAttributes(ResourceAttributes attributes, StringBuilder builder) {
        ArrayList<String> attributesList = new ArrayList<String>(attributes.getAttributeKeySet());
        Collections.sort(attributesList);
        for (String attr : attributesList) {
            List<String> values = attributes.getAttributeValues(attr);
            if (values.isEmpty()) continue;
            builder.append(";");
            LinkFormat.serializeAttribute(attr, values, builder);
        }
    }

    public static StringBuilder serializeAttribute(String key, List<String> values) {
        StringBuilder linkFormat = new StringBuilder();
        LinkFormat.serializeAttribute(key, values, linkFormat);
        return linkFormat;
    }

    public static void serializeAttribute(String key, List<String> values, StringBuilder linkFormat) {
        boolean quotes = false;
        linkFormat.append(key);
        if (values == null) {
            throw new RuntimeException("Values must not be null!");
        }
        if (values.isEmpty() || values.size() == 1 && values.get(0).isEmpty()) {
            return;
        }
        linkFormat.append('=');
        if (values.size() > 1 || !NUMBER.matcher(values.get(0)).matches()) {
            linkFormat.append('\"');
            quotes = true;
        }
        Iterator<String> it = values.iterator();
        while (it.hasNext()) {
            linkFormat.append(it.next());
            if (!it.hasNext()) continue;
            linkFormat.append(' ');
        }
        if (quotes) {
            linkFormat.append('\"');
        }
    }

    @Deprecated
    public static boolean matches(Resource resource, List<String> queries) {
        if (resource == null) {
            return false;
        }
        if (queries == null || queries.isEmpty()) {
            return true;
        }
        return LinkFormat.matches(LinkFormat.createWebLink(resource), queries);
    }

    public static boolean matches(WebLink link, List<String> queries) {
        if (link == null) {
            return false;
        }
        if (queries == null || queries.isEmpty()) {
            return true;
        }
        ResourceAttributes attributes = link.getAttributes();
        Iterator<String> i$ = queries.iterator();
        while (i$.hasNext()) {
            List<String> values;
            String s;
            String attrName = s = i$.next();
            String expected = null;
            boolean prefix = false;
            int delim = s.indexOf(61);
            if (delim != -1) {
                attrName = s.substring(0, delim);
                prefix = s.endsWith("*");
                int end = s.length();
                if (prefix) {
                    --end;
                }
                expected = s.substring(delim + 1, end);
                if (attrName.equals(LINK)) {
                    if (LinkFormat.matches(prefix, expected, link.getURI())) continue;
                    return false;
                }
            }
            if ((values = attributes.getAttributeValues(attrName)).isEmpty()) {
                return false;
            }
            if (expected == null) continue;
            boolean matched = false;
            for (String actual : values) {
                if (!LinkFormat.matches(prefix, expected, actual)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        return true;
    }

    private static boolean matches(boolean prefix, String expected, String value) {
        if (!value.startsWith(expected)) {
            return false;
        }
        return prefix || expected.length() == value.length();
    }

    public static WebLink createWebLink(Resource resource) {
        if (resource == null) {
            throw new NullPointerException("Resource must not be null!");
        }
        WebLink link = new WebLink(LinkFormat.serializePath(resource).toString());
        link.getAttributes().copy(resource.getAttributes());
        return link;
    }

    public static Set<WebLink> parse(String linkFormat) {
        ConcurrentSkipListSet<WebLink> links = new ConcurrentSkipListSet<WebLink>();
        if (linkFormat != null) {
            Scanner scanner = new Scanner(linkFormat);
            String path = null;
            while ((path = scanner.findInLine(TAG)) != null) {
                path = path.substring(1, path.length() - 1);
                WebLink link = new WebLink(path);
                String attr = null;
                while (scanner.findWithinHorizon(SEPARATOR, 1) != null && (attr = scanner.findInLine(WORD)) != null) {
                    if (scanner.findWithinHorizon(EQUAL, 1) != null) {
                        String value = null;
                        value = scanner.findInLine(QUOTED_STRING);
                        if (value != null) {
                            value = value.substring(1, value.length() - 1);
                            if (attr.equals(TITLE)) {
                                link.getAttributes().addAttribute(attr, value);
                                continue;
                            }
                            for (String part : SPACE.split(value)) {
                                link.getAttributes().addAttribute(attr, part);
                            }
                            continue;
                        }
                        value = scanner.findInLine(WORD);
                        if (value != null) {
                            link.getAttributes().setAttribute(attr, value);
                            continue;
                        }
                        value = scanner.findInLine(CARDINAL);
                        if (value != null) {
                            link.getAttributes().setAttribute(attr, value);
                            continue;
                        }
                        if (!scanner.hasNext()) continue;
                        value = scanner.next();
                        continue;
                    }
                    link.getAttributes().addAttribute(attr);
                }
                links.add(link);
                if (scanner.findWithinHorizon(DELIMITER, 1) != null) continue;
                break;
            }
            scanner.close();
        }
        return links;
    }
}

