/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.oscore;

import com.upokecenter.cbor.CBORObject;
import java.io.ByteArrayInputStream;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.OptionSet;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.coap.Token;
import org.eclipse.californium.core.network.serialization.UdpDataParser;
import org.eclipse.californium.cose.Encrypt0Message;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.oscore.ContextRederivation;
import org.eclipse.californium.oscore.Decryptor;
import org.eclipse.californium.oscore.OSCoreCtx;
import org.eclipse.californium.oscore.OSCoreCtxDB;
import org.eclipse.californium.oscore.OSCoreEndpointContextInfo;
import org.eclipse.californium.oscore.OSException;
import org.eclipse.californium.oscore.OptionJuggle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseDecryptor
extends Decryptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResponseDecryptor.class);

    public static Response decrypt(OSCoreCtxDB db, Response response, int requestSequenceNr) throws OSException {
        ResponseDecryptor.discardEOptions(response);
        byte[] protectedData = response.getPayload();
        Encrypt0Message enc = null;
        Token token = response.getToken();
        OSCoreCtx ctx = null;
        OptionSet uOptions = response.getOptions();
        if (token != null) {
            ctx = db.getContextByToken(token);
            if (ctx == null) {
                LOGGER.error("Token is invalid");
                throw new OSException("Token is invalid");
            }
        } else {
            LOGGER.error("Token is null");
            throw new OSException("Token is null");
        }
        enc = ResponseDecryptor.decompression(protectedData, response);
        CBORObject kidContext = enc.findAttribute(CBORObject.FromObject(10));
        byte[] contextID = null;
        if (kidContext != null) {
            contextID = kidContext.GetByteString();
        }
        try {
            ctx = ContextRederivation.incomingResponse(db, ctx, contextID);
        }
        catch (OSException e) {
            LOGGER.error("Security context re-generation failed");
            throw new OSException("Security context re-generation failed");
        }
        try {
            byte[] plaintext = ResponseDecryptor.decryptAndDecode(enc, response, ctx, requestSequenceNr);
            DatagramReader reader = new DatagramReader(new ByteArrayInputStream(plaintext));
            response = OptionJuggle.setRealCodeResponse(response, CoAP.ResponseCode.valueOf(reader.read(8)));
            response.setOptions(EMPTY);
            new UdpDataParser().parseOptionsAndPayload(reader, response);
        }
        catch (Exception e) {
            LOGGER.error("Decryption failed");
            throw new OSException("Decryption failed");
        }
        OptionSet eOptions = response.getOptions();
        eOptions = OptionJuggle.merge(eOptions, uOptions);
        response.setOptions(eOptions);
        if (!response.getOptions().hasObserve()) {
            db.removeToken(token);
        }
        OSCoreEndpointContextInfo.receivingResponse(ctx, response);
        return response;
    }
}

