/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.oscore;

import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.MessageObserverAdapter;
import org.eclipse.californium.core.coap.OptionSet;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.stack.AbstractLayer;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.oscore.CoapOSException;
import org.eclipse.californium.oscore.CoapOSExceptionHandler;
import org.eclipse.californium.oscore.ContextRederivation;
import org.eclipse.californium.oscore.OSCoreCtx;
import org.eclipse.californium.oscore.OSCoreCtxDB;
import org.eclipse.californium.oscore.OSException;
import org.eclipse.californium.oscore.ObjectSecurityLayer;
import org.eclipse.californium.oscore.OscoreOptionDecoder;
import org.eclipse.californium.oscore.RequestDecryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectSecurityContextLayer
extends AbstractLayer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjectSecurityContextLayer.class);
    private final OSCoreCtxDB ctxDb;

    public ObjectSecurityContextLayer(OSCoreCtxDB ctxDb) {
        if (ctxDb == null) {
            throw new NullPointerException("OSCoreCtxDB must be provided!");
        }
        this.ctxDb = ctxDb;
    }

    @Override
    public void receiveRequest(Exchange exchange, Request request) {
        boolean outerBlockwise;
        boolean bl = outerBlockwise = request.getOptions().hasOscore() && request.getOptions().getOscore().length != 0 && exchange.getCurrentRequest() != null && exchange.getCurrentRequest().getOptions().hasBlock1();
        if (ObjectSecurityContextLayer.isProtected(request) && outerBlockwise) {
            byte[] requestOscoreOption;
            LOGGER.debug("Incoming OSCORE request uses outer block-wise");
            OSCoreCtx ctx = null;
            try {
                OscoreOptionDecoder optionDecoder = new OscoreOptionDecoder(request.getOptions().getOscore());
                byte[] rid = optionDecoder.getKid();
                byte[] IDContext = optionDecoder.getIdContext();
                ctx = this.ctxDb.getContext(rid, IDContext);
            }
            catch (CoapOSException e) {
                LOGGER.error("Error while receiving OSCore request: {}", (Object)e.getMessage());
                Response error = CoapOSExceptionHandler.manageError(e, request);
                if (error != null) {
                    super.sendResponse(exchange, error);
                }
                return;
            }
            try {
                request = RequestDecryptor.decrypt(this.ctxDb, request, ctx);
                requestOscoreOption = request.getOptions().getOscore();
                request.getOptions().setOscore(Bytes.EMPTY);
                exchange.setRequest(request);
            }
            catch (CoapOSException e) {
                LOGGER.error("Error while receiving OSCore request: {}", (Object)e.getMessage());
                Response error = CoapOSExceptionHandler.manageError(e, request);
                if (error != null) {
                    super.sendResponse(exchange, error);
                }
                return;
            }
            exchange.setCryptographicContextID(requestOscoreOption);
        }
        super.receiveRequest(exchange, request);
    }

    @Override
    public void sendRequest(final Exchange exchange, final Request request) {
        if (ObjectSecurityContextLayer.shouldProtectRequest(request)) {
            try {
                final String uri = request.getOptions().hasProxyUri() ? request.getOptions().getProxyUri() : request.getURI();
                if (uri == null) {
                    LOGGER.error("URI is null");
                    throw new OSException("URI is null");
                }
                OSCoreCtx ctx = this.ctxDb.getContext(uri);
                if (ctx == null) {
                    LOGGER.error("Context is null");
                    throw new OSException("Context is null");
                }
                if (ctx.getContextRederivationPhase() == ContextRederivation.PHASE.CLIENT_INITIATE) {
                    ContextRederivation.setLostContext(this.ctxDb, uri);
                    final Request startRederivation = Request.newGet();
                    startRederivation.setScheme(request.getScheme());
                    startRederivation.setURI(request.getURI());
                    startRederivation.getOptions().setOscore(Bytes.EMPTY);
                    startRederivation.getOptions().setUriPath("/rederivation/blackhole");
                    startRederivation.addMessageObserver(new MessageObserverAdapter(){

                        @Override
                        public void onResponse(Response response) {
                            try {
                                OSCoreCtx ctx = ObjectSecurityContextLayer.this.ctxDb.getContext(uri);
                                if (ctx == null) {
                                    LOGGER.error("Context is null");
                                } else if (ctx.getContextRederivationPhase() != ContextRederivation.PHASE.CLIENT_PHASE_2) {
                                    LOGGER.error("Expected phase 2, but is {}", (Object)ctx.getContextRederivationPhase());
                                }
                            }
                            catch (OSException oSException) {
                                // empty catch block
                            }
                            exchange.execute(new Runnable(){

                                @Override
                                public void run() {
                                    LOGGER.debug("Original Request: {}", (Object)exchange.getRequest());
                                    ObjectSecurityContextLayer.super.sendRequest(exchange, request);
                                }
                            });
                        }

                        @Override
                        public void onReject() {
                            request.setRejected(true);
                        }

                        @Override
                        public void onCancel() {
                            request.setCanceled(true);
                        }

                        @Override
                        public void onTimeout() {
                            request.setTimedOut(true);
                        }

                        @Override
                        public void onConnecting() {
                            request.onConnecting();
                        }

                        @Override
                        public void onDtlsRetransmission(int flight) {
                            request.onDtlsRetransmission(flight);
                        }

                        @Override
                        public void onSendError(Throwable error) {
                            request.setSendError(error);
                        }
                    });
                    LOGGER.debug("Auxiliary Request: {}", (Object)exchange.getRequest());
                    final Exchange newExchange = new Exchange(startRederivation, exchange.getPeersIdentity(), Exchange.Origin.LOCAL, this.executor);
                    newExchange.execute(new Runnable(){

                        @Override
                        public void run() {
                            ObjectSecurityContextLayer.super.sendRequest(newExchange, startRederivation);
                        }
                    });
                    return;
                }
            }
            catch (OSException e) {
                LOGGER.error("Error sending request: {}", (Object)e.getMessage());
                return;
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Unable to send request because of illegal argument: {}", (Object)e.getMessage());
                return;
            }
        }
        LOGGER.trace("Request: {}", (Object)exchange.getRequest());
        super.sendRequest(exchange, request);
    }

    @Override
    public void receiveResponse(Exchange exchange, Response response) {
        boolean outerBlockwise;
        Response rawResponse = exchange.getCurrentResponse();
        boolean bl = outerBlockwise = rawResponse != null && rawResponse.getOptions().hasBlock2() && this.ctxDb.getContextByToken(rawResponse.getToken()) != null;
        if (outerBlockwise) {
            LOGGER.debug("Incoming OSCORE response uses outer block-wise");
            Request request = exchange.getCurrentRequest();
            if (request == null) {
                LOGGER.error("No request tied to this response");
                return;
            }
            try {
                if (ObjectSecurityContextLayer.isProtected(response)) {
                    OscoreOptionDecoder optionDecoder = new OscoreOptionDecoder(exchange.getCryptographicContextID());
                    int requestSequenceNumber = optionDecoder.getSequenceNumber();
                    response = ObjectSecurityLayer.prepareReceive(this.ctxDb, response, requestSequenceNumber);
                }
            }
            catch (OSException e) {
                LOGGER.error("Error while receiving OSCore response: {}", (Object)e.getMessage());
                EmptyMessage error = CoapOSExceptionHandler.manageError(e, response);
                if (error != null) {
                    this.sendEmptyMessage(exchange, error);
                }
                return;
            }
            if (exchange.getRequest().isObserveCancel()) {
                this.ctxDb.removeToken(response.getToken());
            }
        }
        super.receiveResponse(exchange, response);
    }

    private static boolean shouldProtectRequest(Request request) {
        OptionSet options = request.getOptions();
        return options.hasOscore();
    }

    private static boolean isProtected(Message message) {
        OptionSet options = message.getOptions();
        return options.hasOscore();
    }
}

