/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.californium.elements.util.ClockUtil;
import org.eclipse.californium.elements.util.NamedThreadFactory;
import org.eclipse.californium.elements.util.NotForAndroid;
import org.eclipse.californium.elements.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorsUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutorsUtil.class);
    private static final Runnable WARMUP = new Runnable(){

        @Override
        public void run() {
            LOGGER.trace("warmup ...");
        }
    };
    public static final ThreadGroup TIMER_THREAD_GROUP = new ThreadGroup("Timer");
    private static final int SPLIT_THRESHOLD = 1;
    private static final Boolean DEFAULT_REMOVE_ON_CANCEL = true;
    private static final Boolean REMOVE_ON_CANCEL;

    public static ScheduledExecutorService newScheduledThreadPool(int poolSize, ThreadFactory threadFactory) {
        if (poolSize <= 1) {
            LOGGER.trace("create scheduled thread pool of {} threads", (Object)poolSize);
            ScheduledExecutorService executor = Executors.newScheduledThreadPool(poolSize, threadFactory);
            ExecutorsUtil.setRemoveOnCancelPolicy(executor);
            executor.execute(WARMUP);
            return executor;
        }
        LOGGER.trace("create special thread pool of {} threads", (Object)poolSize);
        SplitScheduledThreadPoolExecutor executor = new SplitScheduledThreadPoolExecutor(poolSize, threadFactory);
        executor.execute(WARMUP);
        executor.schedule(WARMUP, 0L, TimeUnit.NANOSECONDS);
        return executor;
    }

    public static ExecutorService newFixedThreadPool(int poolSize, ThreadFactory threadFactory) {
        LOGGER.trace("create thread pool of {} threads", (Object)poolSize);
        ExecutorService executor = Executors.newFixedThreadPool(poolSize, threadFactory);
        executor.execute(WARMUP);
        return executor;
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(ThreadFactory threadFactory) {
        LOGGER.trace("create scheduled single thread pool");
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(threadFactory);
        ExecutorsUtil.setRemoveOnCancelPolicy(executor);
        executor.execute(WARMUP);
        return executor;
    }

    public static ScheduledThreadPoolExecutor newDefaultSecondaryScheduler(String namePrefix) {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(2, new NamedThreadFactory(namePrefix));
        ExecutorsUtil.setRemoveOnCancelPolicy(executor);
        executor.execute(WARMUP);
        executor.prestartAllCoreThreads();
        return executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownExecutorGracefully(long timeMaxToWaitInMs, ExecutorService ... executors) {
        if (executors.length == 0) {
            return;
        }
        long start = ClockUtil.nanoRealtime();
        for (ExecutorService executor : executors) {
            executor.shutdown();
        }
        long time = TimeUnit.NANOSECONDS.toMillis(ClockUtil.nanoRealtime() - start);
        if (time > timeMaxToWaitInMs) {
            LOGGER.warn("shutdown {} ms exceeded the maximum {} ms", (Object)time, (Object)timeMaxToWaitInMs);
        }
        try {
            long timeToWait = timeMaxToWaitInMs / (long)executors.length / 2L;
            for (ExecutorService executor : executors) {
                if (executor.awaitTermination(timeToWait, TimeUnit.MILLISECONDS)) continue;
                List<Runnable> runningTasks = executor.shutdownNow();
                if (runningTasks.size() > 0) {
                    LOGGER.debug("ignoring remaining {} scheduled task(s)", (Object)runningTasks.size());
                }
                executor.awaitTermination(timeToWait, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException e) {
            for (ExecutorService executor : executors) {
                executor.shutdownNow();
            }
            Thread.currentThread().interrupt();
        }
        finally {
            time = TimeUnit.NANOSECONDS.toMillis(ClockUtil.nanoRealtime() - start);
            if (time > timeMaxToWaitInMs) {
                LOGGER.warn("await termination {} ms exceeded the maximum {} ms", (Object)time, (Object)timeMaxToWaitInMs);
            }
        }
    }

    public static void runAll(List<Runnable> jobs) {
        for (Runnable job : jobs) {
            try {
                job.run();
            }
            catch (Throwable e) {
                LOGGER.warn("Ignoring error:", e);
            }
        }
    }

    @NotForAndroid
    private static void setRemoveOnCancelPolicy(ScheduledExecutorService executor) {
        if (REMOVE_ON_CANCEL != null && executor instanceof ScheduledThreadPoolExecutor) {
            ((ScheduledThreadPoolExecutor)executor).setRemoveOnCancelPolicy(REMOVE_ON_CANCEL);
        }
    }

    static {
        Boolean remove = StringUtil.getConfigurationBoolean("EXECUTER_REMOVE_ON_CANCEL");
        if (remove == null) {
            remove = DEFAULT_REMOVE_ON_CANCEL;
        }
        if (remove != null) {
            try {
                ScheduledThreadPoolExecutor.class.getMethod("setRemoveOnCancelPolicy", Boolean.TYPE);
            }
            catch (NoSuchMethodException e) {
                remove = null;
            }
        }
        REMOVE_ON_CANCEL = remove;
    }

    private static class SplitScheduledThreadPoolExecutor
    extends ScheduledThreadPoolExecutor {
        private final long SCHEDULE_EXECUTOR_LOGGING_QUEUE_SIZE_DIFF_DEFAULT = 10000L;
        private final ExecutorService directExecutor;
        private AtomicLong scheduleQueueSize = new AtomicLong();
        private final long scheduleLoggingQueueSizeDiff;

        public SplitScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory) {
            super(corePoolSize < 1 ? corePoolSize : 1, threadFactory);
            this.setMaximumPoolSize(corePoolSize < 1 ? corePoolSize : 1);
            Long diff = StringUtil.getConfigurationLong("EXECUTER_LOGGING_QUEUE_SIZE_DIFF");
            this.scheduleLoggingQueueSizeDiff = diff == null ? 10000L : diff;
            ExecutorsUtil.setRemoveOnCancelPolicy(this);
            this.directExecutor = corePoolSize > 1 ? ExecutorsUtil.newFixedThreadPool(corePoolSize - 1, threadFactory) : null;
            LOGGER.debug("remove on cancel: {}, split: {}, log-diff: {}", REMOVE_ON_CANCEL, this.directExecutor != null, this.scheduleLoggingQueueSizeDiff);
        }

        @Override
        public void execute(Runnable command) {
            if (this.directExecutor == null) {
                super.execute(command);
            } else {
                long size;
                long lastSize = this.scheduleQueueSize.get();
                long diff = Math.abs(lastSize - (size = (long)this.getQueue().size()));
                if (diff > this.scheduleLoggingQueueSizeDiff && this.scheduleQueueSize.compareAndSet(lastSize, size)) {
                    LOGGER.debug("Job queue {}", (Object)size);
                    this.purge();
                }
                this.directExecutor.execute(command);
            }
        }

        @Override
        public Future<?> submit(Runnable task) {
            if (this.directExecutor == null) {
                return super.submit(task);
            }
            return this.directExecutor.submit(task);
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            if (this.directExecutor == null) {
                return super.submit(task, result);
            }
            return this.directExecutor.submit(task, result);
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            if (this.directExecutor == null) {
                return super.submit(task);
            }
            return this.directExecutor.submit(task);
        }

        @Override
        public void shutdown() {
            if (this.directExecutor != null) {
                this.directExecutor.shutdown();
            }
            super.shutdown();
        }

        @Override
        public List<Runnable> shutdownNow() {
            List<Runnable> result = super.shutdownNow();
            if (this.directExecutor != null) {
                result.addAll(this.directExecutor.shutdownNow());
            }
            return result;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            if (this.directExecutor != null) {
                if (!this.directExecutor.awaitTermination(timeout / 2L, unit)) {
                    return false;
                }
                return super.awaitTermination(timeout / 2L, unit);
            }
            return super.awaitTermination(timeout, unit);
        }
    }
}

