/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack.congestioncontrol;

import org.eclipse.californium.core.network.stack.CongestionControlLayer;
import org.eclipse.californium.core.network.stack.RemoteEndpoint;
import org.eclipse.californium.elements.config.Configuration;

public class PeakhopperRto
extends CongestionControlLayer {
    public PeakhopperRto(String tag, Configuration config) {
        super(tag, config);
    }

    @Override
    protected RemoteEndpoint createRemoteEndpoint(Object peersIdentity) {
        return new PeakhopperRemoteEndoint(peersIdentity, this.defaultReliabilityLayerParameters.getAckTimeout(), this.defaultReliabilityLayerParameters.getNstart());
    }

    private static class PeakhopperRemoteEndoint
    extends RemoteEndpoint {
        private float delta;
        private float B_value;
        private static final float F_value = 24.0f;
        private static final float B_max_value = 1.0f;
        private static final float D_value = 0.9583333f;
        private static final int RTT_HISTORY_SIZE = 2;
        private long RTO_min;
        private long RTT_max;
        private long RTT_previous;
        private long[] RTT_sample = new long[2];
        private int currentRtt;

        private PeakhopperRemoteEndoint(Object peersIdentity, int ackTimeout, int nstart) {
            super(peersIdentity, ackTimeout, nstart, true);
        }

        private void initializeRTOEstimators(long measuredRTT) {
            this.addRttValue(measuredRTT);
            long newRTO = (long)(1.75 * (double)measuredRTT);
            this.updateRTO(newRTO);
        }

        private void updateEstimator(long measuredRTT) {
            this.addRttValue(measuredRTT);
            this.delta = Math.abs((measuredRTT - this.RTT_previous) / measuredRTT);
            this.B_value = Math.min(Math.max(this.delta * 2.0f, 0.9583333f * this.B_value), 1.0f);
            this.RTT_max = Math.max(measuredRTT, this.RTT_previous);
            this.RTO_min = this.getMaxRtt() + 100L;
            long newRTO = (long)Math.max(0.9583333f * (float)this.getRTO(), (1.0f + this.B_value) * (float)this.RTT_max);
            newRTO = Math.max(Math.max(newRTO, this.RTT_max + 100L), this.RTO_min);
            this.printPeakhopperStats();
            this.RTT_previous = measuredRTT;
            this.updateRTO(newRTO);
        }

        @Override
        public synchronized void processRttMeasurement(RemoteEndpoint.RtoType rtoType, long measuredRTT) {
            if (rtoType != RemoteEndpoint.RtoType.STRONG) {
                return;
            }
            if (this.initialRto()) {
                this.initializeRTOEstimators(measuredRTT);
            } else {
                this.updateEstimator(measuredRTT);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addRttValue(long rtt) {
            long[] lArray = this.RTT_sample;
            synchronized (this.RTT_sample) {
                this.RTT_sample[this.currentRtt++] = rtt;
                if (this.currentRtt >= this.RTT_sample.length) {
                    this.currentRtt = 0;
                }
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long getMaxRtt() {
            long max = -1L;
            long[] lArray = this.RTT_sample;
            synchronized (this.RTT_sample) {
                for (long rtt : this.RTT_sample) {
                    max = Math.max(max, rtt);
                }
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return max;
            }
        }

        private void printPeakhopperStats() {
            LOGGER.trace("Delta: {}, D: {}, B: {}, RTT_max: {}", Float.valueOf(this.delta), Float.valueOf(0.9583333f), Float.valueOf(this.B_value), this.RTT_max);
        }
    }
}

