/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap.option;

import org.eclipse.californium.core.coap.OptionNumberRegistry;
import org.eclipse.californium.core.coap.option.EmptyOptionDefinition;
import org.eclipse.californium.core.coap.option.IntegerOptionDefinition;
import org.eclipse.californium.core.coap.option.LegacyMapBasedOptionRegistry;
import org.eclipse.californium.core.coap.option.MapBasedOptionRegistry;
import org.eclipse.californium.core.coap.option.OpaqueOptionDefinition;
import org.eclipse.californium.core.coap.option.OptionRegistry;
import org.eclipse.californium.core.coap.option.StringOptionDefinition;

public class StandardOptionRegistry
extends MapBasedOptionRegistry {
    public static final OpaqueOptionDefinition IF_MATCH = new OpaqueOptionDefinition(1, "If-Match", false, 0, 8);
    public static final StringOptionDefinition URI_HOST = new StringOptionDefinition(3, "Uri-Host", true, 1, 255);
    public static final OpaqueOptionDefinition ETAG = new OpaqueOptionDefinition(4, "ETag", false, 1, 8);
    public static final EmptyOptionDefinition IF_NONE_MATCH = new EmptyOptionDefinition(5, "If-None-Match");
    public static final IntegerOptionDefinition URI_PORT = new IntegerOptionDefinition(7, "Uri-Port", true, 0, 2);
    public static final StringOptionDefinition LOCATION_PATH = new StringOptionDefinition(8, "Location-Path", false, 0, 255);
    public static final StringOptionDefinition URI_PATH = new StringOptionDefinition(11, "Uri-Path", false, 0, 255);
    public static final IntegerOptionDefinition CONTENT_FORMAT = new IntegerOptionDefinition(12, "Content-Format", true, 0, 2);
    public static final IntegerOptionDefinition MAX_AGE = new IntegerOptionDefinition(14, "Max-Age", true, 0, 4);
    public static final StringOptionDefinition URI_QUERY = new StringOptionDefinition(15, "Uri-Query", false, 0, 255);
    public static final IntegerOptionDefinition ACCEPT = new IntegerOptionDefinition(17, "Accept", true, 0, 2);
    public static final IntegerOptionDefinition Q_BLOCK_1 = new IntegerOptionDefinition(19, "Q-Block-1", true, 0, 3);
    public static final StringOptionDefinition LOCATION_QUERY = new StringOptionDefinition(20, "Location-Query", false, 0, 255);
    public static final StringOptionDefinition PROXY_URI = new StringOptionDefinition(35, "Proxy-Uri", true, 1, 1034);
    public static final StringOptionDefinition PROXY_SCHEME = new StringOptionDefinition(39, "Proxy-Scheme", true, 1, 255);
    public static final IntegerOptionDefinition SIZE1 = new IntegerOptionDefinition(60, "Size1", true, 0, 4);
    public static final IntegerOptionDefinition OBSERVE = new IntegerOptionDefinition(6, "Observe", true, 0, 3);
    public static final IntegerOptionDefinition BLOCK1 = new IntegerOptionDefinition(27, "Block1", true, 0, 3);
    public static final IntegerOptionDefinition BLOCK2 = new IntegerOptionDefinition(23, "Block2", true, 0, 3);
    public static final IntegerOptionDefinition SIZE2 = new IntegerOptionDefinition(28, "Size2", true, 0, 4);
    public static final IntegerOptionDefinition Q_BLOCK_2 = new IntegerOptionDefinition(31, "Q-Block-2", false, 0, 3);
    public static final OpaqueOptionDefinition OSCORE = new OpaqueOptionDefinition(9, "Object-Security", true, 0, 255);
    public static final OpaqueOptionDefinition ECHO = new OpaqueOptionDefinition(252, "Echo", true, 1, 40);
    public static final IntegerOptionDefinition NO_RESPONSE = new IntegerOptionDefinition(258, "No-Response", true, 0, 1);
    public static final OpaqueOptionDefinition REQUEST_TAG = new OpaqueOptionDefinition(292, "Request-Tag", true, 0, 8);
    public static final OptionRegistry STANDARD_OPTIONS = new StandardOptionRegistry();
    private static volatile OptionRegistry defaultRegistry;

    private StandardOptionRegistry() {
        super(IF_MATCH, URI_HOST, ETAG, IF_NONE_MATCH, URI_PORT, LOCATION_PATH, URI_PATH, CONTENT_FORMAT, MAX_AGE, URI_QUERY, ACCEPT, Q_BLOCK_1, LOCATION_QUERY, PROXY_URI, PROXY_SCHEME, SIZE1, OBSERVE, BLOCK1, BLOCK2, SIZE2, Q_BLOCK_2, OSCORE, ECHO, NO_RESPONSE, REQUEST_TAG);
    }

    public static OptionRegistry getDefaultOptionRegistry() {
        return defaultRegistry;
    }

    public static OptionRegistry setDefaultOptionRegistry(OptionRegistry registry) {
        OptionRegistry previous = defaultRegistry;
        defaultRegistry = registry == null ? new LegacyMapBasedOptionRegistry(true, OptionNumberRegistry.getCustomOptionNumberRegistry(), STANDARD_OPTIONS) : registry;
        return previous;
    }

    static {
        StandardOptionRegistry.setDefaultOptionRegistry(null);
    }
}

