/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.cipher;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.List;
import org.eclipse.californium.elements.config.CertificateAuthenticationMode;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.eclipse.californium.scandium.dtls.SupportedPointFormatsExtension;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.cipher.XECDHECryptography;

public class CipherSuiteParameters {
    private GeneralMismatch generalMismatch;
    private CertificateBasedMismatch certificateMismatch;
    private PublicKey publicKey;
    private List<X509Certificate> certificateChain;
    private CertificateAuthenticationMode clientAuthenticationMode;
    private List<CipherSuite> cipherSuites;
    private List<CertificateType> serverCertTypes;
    private List<CertificateType> clientCertTypes;
    private List<XECDHECryptography.SupportedGroup> supportedGroups;
    private List<SignatureAndHashAlgorithm> signatures;
    private SupportedPointFormatsExtension.ECPointFormat format;
    private CipherSuite selectedCipherSuite;
    private CertificateType selectedServerCertificateType;
    private CertificateType selectedClientCertificateType;
    private SignatureAndHashAlgorithm selectedSignature;
    private XECDHECryptography.SupportedGroup selectedSupportedGroup;

    public CipherSuiteParameters(PublicKey publicKey, List<X509Certificate> certificateChain, CertificateAuthenticationMode clientAuthenticationMode, List<CipherSuite> cipherSuites, List<CertificateType> serverCertTypes, List<CertificateType> clientCertTypes, List<XECDHECryptography.SupportedGroup> supportedGroups, List<SignatureAndHashAlgorithm> signatures, SupportedPointFormatsExtension.ECPointFormat format) {
        this.publicKey = publicKey;
        this.certificateChain = certificateChain;
        this.clientAuthenticationMode = clientAuthenticationMode;
        this.cipherSuites = cipherSuites;
        this.serverCertTypes = serverCertTypes;
        this.clientCertTypes = clientCertTypes;
        this.supportedGroups = supportedGroups;
        this.signatures = signatures;
        this.format = format;
    }

    public CipherSuiteParameters(PublicKey publicKey, List<X509Certificate> certificateChain, CipherSuiteParameters others) {
        this.publicKey = publicKey;
        this.certificateChain = certificateChain;
        this.clientAuthenticationMode = others.clientAuthenticationMode;
        this.cipherSuites = others.cipherSuites;
        this.serverCertTypes = others.serverCertTypes;
        this.clientCertTypes = others.clientCertTypes;
        this.supportedGroups = others.supportedGroups;
        this.signatures = others.signatures;
        this.format = others.format;
        this.selectedCipherSuite = others.selectedCipherSuite;
        this.selectedServerCertificateType = others.selectedServerCertificateType;
        this.selectedClientCertificateType = others.selectedClientCertificateType;
        this.selectedSupportedGroup = others.selectedSupportedGroup;
        this.selectedSignature = others.selectedSignature;
    }

    public List<CipherSuite> getCipherSuites() {
        return this.cipherSuites;
    }

    public List<CertificateType> getServerCertTypes() {
        return this.serverCertTypes;
    }

    public List<CertificateType> getClientCertTypes() {
        return this.clientCertTypes;
    }

    public List<XECDHECryptography.SupportedGroup> getSupportedGroups() {
        return this.supportedGroups;
    }

    public List<SignatureAndHashAlgorithm> getSignatures() {
        return this.signatures;
    }

    public SupportedPointFormatsExtension.ECPointFormat getFormat() {
        return this.format;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public List<X509Certificate> getCertificateChain() {
        return this.certificateChain;
    }

    public GeneralMismatch getGeneralMismatch() {
        return this.generalMismatch;
    }

    public CertificateBasedMismatch getCertificateMismatch() {
        return this.certificateMismatch;
    }

    public CertificateAuthenticationMode getClientAuthenticationMode() {
        return this.clientAuthenticationMode;
    }

    public CipherSuite getSelectedCipherSuite() {
        return this.selectedCipherSuite;
    }

    public CertificateType getSelectedServerCertificateType() {
        return this.selectedServerCertificateType;
    }

    public CertificateType getSelectedClientCertificateType() {
        return this.selectedClientCertificateType;
    }

    public XECDHECryptography.SupportedGroup getSelectedSupportedGroup() {
        return this.selectedSupportedGroup;
    }

    public SignatureAndHashAlgorithm getSelectedSignature() {
        return this.selectedSignature;
    }

    public void setGeneralMismatch(GeneralMismatch mismatch) {
        this.generalMismatch = mismatch;
    }

    public void setCertificateMismatch(CertificateBasedMismatch mismatch) {
        this.certificateMismatch = mismatch;
    }

    public void select(CipherSuite cipherSuite) {
        if (cipherSuite == null) {
            throw new NullPointerException("Cipher suite must not be null!");
        }
        if (!this.cipherSuites.contains((Object)cipherSuite)) {
            throw new IllegalArgumentException((Object)((Object)cipherSuite) + " is no common cipher suite!");
        }
        this.selectedCipherSuite = cipherSuite;
    }

    public void selectServerCertificateType(CertificateType type) {
        if (type != null && !this.serverCertTypes.contains((Object)type)) {
            throw new IllegalArgumentException((Object)((Object)type) + " server certificate type is no common certificate type.");
        }
        this.selectedServerCertificateType = type;
    }

    public void selectClientCertificateType(CertificateType type) {
        if (type != null && !this.clientCertTypes.contains((Object)type)) {
            throw new IllegalArgumentException((Object)((Object)type) + " client certificate type is no common certificate type.");
        }
        this.selectedClientCertificateType = type;
    }

    public void selectSupportedGroup(XECDHECryptography.SupportedGroup group) {
        if (group != null && !this.supportedGroups.contains((Object)group)) {
            throw new IllegalArgumentException((Object)((Object)group) + " is no common group/curve.");
        }
        this.selectedSupportedGroup = group;
    }

    public void selectSignatureAndHashAlgorithm(SignatureAndHashAlgorithm signature) {
        if (signature != null && !this.signatures.contains(signature)) {
            throw new IllegalArgumentException(signature + " is no common signature and hash algorithm.");
        }
        this.selectedSignature = signature;
    }

    public String getMismatchSummary() {
        if (this.generalMismatch != null) {
            return this.generalMismatch.getMessage();
        }
        if (this.certificateMismatch != null) {
            return this.certificateMismatch.getMessage();
        }
        return null;
    }

    public String getMismatchDescription() {
        String summary = this.getMismatchSummary();
        if (summary != null) {
            StringBuilder builder = new StringBuilder(summary);
            builder.append(StringUtil.lineSeparator());
            builder.append("\tcipher suites: ");
            for (CipherSuite cipherSuite : this.cipherSuites) {
                builder.append(cipherSuite.name()).append(",");
            }
            builder.setLength(builder.length() - 1);
            if (this.certificateMismatch == CertificateBasedMismatch.CERTIFICATE_EC_GROUPS) {
                builder.append(StringUtil.lineSeparator()).append("\t\tec-groups: ");
                for (XECDHECryptography.SupportedGroup group : this.supportedGroups) {
                    builder.append(group.name()).append(",");
                }
                builder.setLength(builder.length() - 1);
            } else if (this.certificateMismatch == CertificateBasedMismatch.CERTIFICATE_SIGNATURE_ALGORITHMS || this.certificateMismatch == CertificateBasedMismatch.CERTIFICATE_PATH_SIGNATURE_ALGORITHMS) {
                builder.append(StringUtil.lineSeparator()).append("\t\tsignatures: ");
                for (SignatureAndHashAlgorithm sign : this.signatures) {
                    builder.append(sign.getJcaName()).append(",");
                }
                builder.setLength(builder.length() - 1);
            }
            return builder.toString();
        }
        return summary;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("cipher suites: ");
        for (CipherSuite cipherSuite : this.cipherSuites) {
            if (this.selectedCipherSuite == cipherSuite) {
                builder.append("#");
            }
            builder.append(cipherSuite.name()).append(",");
        }
        builder.setLength(builder.length() - 1);
        builder.append(StringUtil.lineSeparator());
        if (this.certificateChain != null && !this.certificateChain.isEmpty()) {
            builder.append("x509-DN: [").append(this.certificateChain.get(0).getSubjectX500Principal().getName());
            builder.append("]").append(StringUtil.lineSeparator());
        }
        if (this.publicKey != null) {
            if (this.clientAuthenticationMode == CertificateAuthenticationMode.NEEDED) {
                builder.append("client certificate required");
            } else if (this.clientAuthenticationMode == CertificateAuthenticationMode.WANTED) {
                builder.append("client certificate wanted");
            } else {
                builder.append("no client certificate");
            }
            builder.append(StringUtil.lineSeparator());
        }
        builder.append("server certificate types: ");
        for (CertificateType cerType : this.serverCertTypes) {
            if (this.selectedServerCertificateType == cerType) {
                builder.append("#");
            }
            builder.append(cerType.name()).append(",");
        }
        builder.setLength(builder.length() - 1);
        builder.append(StringUtil.lineSeparator());
        builder.append("client certificate types: ");
        for (CertificateType cerType : this.clientCertTypes) {
            if (this.selectedClientCertificateType == cerType) {
                builder.append("#");
            }
            builder.append(cerType.name()).append(",");
        }
        builder.setLength(builder.length() - 1);
        builder.append(StringUtil.lineSeparator());
        builder.append("ec-groups: ");
        for (XECDHECryptography.SupportedGroup group : this.supportedGroups) {
            if (this.selectedSupportedGroup == group) {
                builder.append("#");
            }
            builder.append(group.name()).append(",");
        }
        builder.setLength(builder.length() - 1);
        builder.append(StringUtil.lineSeparator());
        builder.append("signatures: ");
        for (SignatureAndHashAlgorithm sign : this.signatures) {
            if (this.selectedSignature == sign) {
                builder.append("#");
            }
            builder.append(sign.getJcaName()).append(",");
        }
        builder.setLength(builder.length() - 1);
        builder.append(StringUtil.lineSeparator());
        return builder.toString();
    }

    public static enum CertificateBasedMismatch {
        SERVER_CERT_TYPE("Peers have no common server certificate type."),
        CLIENT_CERT_TYPE("Peers have no common client certificate type."),
        SIGNATURE_ALGORITHMS("Peers have no common signature and hash algorithm."),
        CERTIFICATE_EC_GROUPS("The peer's node certificate uses no common ec-group."),
        CERTIFICATE_SIGNATURE_ALGORITHMS("The peer's node certificate uses no common signature and hash algorithm."),
        CERTIFICATE_PATH_SIGNATURE_ALGORITHMS("The peer's certificate-chain uses no common signature and hash algorithm.");

        private final String message;

        private CertificateBasedMismatch(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static enum GeneralMismatch {
        CIPHER_SUITE("Peers have no common cipher suite."),
        EC_FORMAT("Peers have no common ec-point format."),
        EC_GROUPS("Peers have no common ec-groups.");

        private final String message;

        private GeneralMismatch(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

