/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.oscore;

import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.oscore.CoapOSException;
import org.eclipse.californium.oscore.OSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoapOSExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoapOSExceptionHandler.class);

    public static Response manageError(CoapOSException e, Request request) {
        CoAP.ResponseCode responseCode = e.getResponseCode();
        Response error = null;
        if (request != null) {
            if (request.getType() != null) {
                if (responseCode.isClientError()) {
                    error = Response.createResponse(request, responseCode);
                    CoAP.Type tmp = CoAP.Type.NON;
                    CoAP.Type t = request.getType();
                    if (t.equals((Object)CoAP.Type.CON)) {
                        tmp = CoAP.Type.ACK;
                    }
                    error.setType(tmp);
                    error.setPayload(e.getMessage());
                    error.getOptions().setMaxAge(0L);
                    error.setMID(request.getMID());
                    error.getOptions().setContentFormat(0);
                    return error;
                }
                LOGGER.error("{} {}", (Object)"Cannot create error message for this error", (Object)"Error message is null");
            } else {
                LOGGER.error("{} {}", (Object)"Cannot create error message for this error", (Object)"Type is null");
            }
        } else {
            LOGGER.error("{} {}", (Object)"Cannot create error message for this error", (Object)"Request is null");
        }
        return null;
    }

    public static EmptyMessage manageError(OSException e, Response response) {
        if (e == null) {
            LOGGER.error("Exception is null");
            throw new NullPointerException("Exception is null");
        }
        String errMess = e.getMessage();
        if (errMess == null) {
            LOGGER.error("Error message is null");
            throw new NullPointerException("Error message is null");
        }
        if (!response.isConfirmable()) {
            LOGGER.error("An Empty Message will not be created");
            return null;
        }
        LOGGER.debug("Sending empty RST message");
        return EmptyMessage.newRST(response);
    }
}

