/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.elements.PersistentComponent;
import org.eclipse.californium.elements.PersistentComponentProvider;
import org.eclipse.californium.elements.util.DataStreamReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.SerializationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentComponentUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(PersistentComponentUtil.class);
    private static final String MARK = "COMPONENTS";
    private final List<PersistentComponentProvider> providers = new ArrayList<PersistentComponentProvider>();
    private final ConcurrentMap<String, PersistentComponent> components = new ConcurrentHashMap<String, PersistentComponent>();
    private final ConcurrentMap<String, PersistentComponent> all = new ConcurrentHashMap<String, PersistentComponent>();

    public void updateProvidersComponents() {
        this.all.clear();
        this.all.putAll(this.components);
        for (PersistentComponentProvider provider : this.providers) {
            for (PersistentComponent component : provider.getComponents()) {
                this.all.put(component.getLabel(), component);
            }
        }
    }

    public void addProvider(PersistentComponentProvider provider) {
        this.providers.remove(provider);
        this.providers.add(provider);
        for (PersistentComponent component : provider.getComponents()) {
            this.all.put(component.getLabel(), component);
        }
    }

    public void removeProvider(PersistentComponentProvider provider) {
        this.providers.remove(provider);
        for (PersistentComponent component : provider.getComponents()) {
            this.all.remove(component.getLabel(), component);
        }
    }

    public void add(PersistentComponent component) {
        this.components.put(component.getLabel(), component);
        this.all.put(component.getLabel(), component);
    }

    public void remove(PersistentComponent component) {
        this.components.remove(component.getLabel(), component);
        this.all.remove(component.getLabel(), component);
    }

    public boolean isEmpty() {
        return this.all.isEmpty();
    }

    public int loadComponents(InputStream in) {
        long time = System.nanoTime();
        int count = 0;
        try {
            in.mark(32);
            DataStreamReader reader = new DataStreamReader(in);
            long delta = SerializationUtil.readNanotimeSynchronizationMark(reader);
            String mark = SerializationUtil.readString(reader, 8);
            if (!MARK.equals(mark)) {
                LOGGER.info("Mismatch, {} != {}", (Object)MARK, (Object)mark);
                in.reset();
                return -1;
            }
            count = this.load(in, delta);
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("loading failed:", e);
        }
        catch (IOException e) {
            LOGGER.warn("loading failed:", e);
        }
        time = System.nanoTime() - time;
        LOGGER.info("load: {} ms, {} items", (Object)TimeUnit.NANOSECONDS.toMillis(time), (Object)count);
        return count;
    }

    public int saveComponents(OutputStream out, long staleThresholdInSeconds) throws IOException {
        long start = System.nanoTime();
        DatagramWriter writer = new DatagramWriter();
        SerializationUtil.writeNanotimeSynchronizationMark(writer);
        SerializationUtil.write(writer, MARK, 8);
        writer.writeTo(out);
        int count = this.save(out, staleThresholdInSeconds);
        long time = System.nanoTime() - start;
        LOGGER.info("save: {} ms, {} connections", (Object)TimeUnit.NANOSECONDS.toMillis(time), (Object)count);
        return count;
    }

    public int load(InputStream in, long deltaNanos) {
        int count = 0;
        ArrayList<String> failed = new ArrayList<String>();
        try {
            String label;
            while ((label = SerializationUtil.readString(new DataStreamReader(in), 16)) != null) {
                PersistentComponent component = (PersistentComponent)this.all.get(label);
                if (component != null) {
                    int loaded = component.load(in, deltaNanos);
                    LOGGER.info("loading {}, {} items, {} components.", label, loaded, this.all.size());
                    count += loaded;
                    continue;
                }
                int skip = SerializationUtil.skipItems(new DataStreamReader(in), 16);
                LOGGER.warn("loading {} failed, {} items skipped, no component found!", (Object)label, (Object)skip);
                failed.add(label);
            }
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("loading failed:", e);
        }
        catch (IOException e) {
            LOGGER.warn("loading failed:", e);
        }
        if (!failed.isEmpty()) {
            LOGGER.warn("Loading failures:");
            int index = 0;
            for (String label : failed) {
                LOGGER.warn("[LOAD {}] {}", (Object)index++, (Object)label);
            }
            index = 0;
            for (String label : this.all.keySet()) {
                LOGGER.warn("[COMP {}] {}", (Object)index++, (Object)label);
            }
        }
        return count;
    }

    public int save(OutputStream out, long staleThresholdInSeconds) throws IOException {
        int count = 0;
        DatagramWriter writer = new DatagramWriter();
        for (PersistentComponent component : this.all.values()) {
            String label = component.getLabel();
            SerializationUtil.write(writer, label, 16);
            writer.writeTo(out);
            int saved = component.save(out, staleThresholdInSeconds);
            LOGGER.info("saved: {} items of {}", (Object)saved, (Object)label);
            count += saved;
        }
        SerializationUtil.write(writer, null, 16);
        writer.writeTo(out);
        return count;
    }
}

