/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack.congestioncontrol;

import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.core.network.stack.CongestionControlLayer;
import org.eclipse.californium.core.network.stack.RemoteEndpoint;
import org.eclipse.californium.core.network.stack.congestioncontrol.Rto;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.util.ClockUtil;

public class Cocoa
extends CongestionControlLayer {
    private static final int KSTRONG = 4;
    private static final int KWEAK = 1;
    private static final double STRONGWEIGHTING = 0.5;
    private static final double WEAKWEIGHTING = 0.25;
    private static final long LOWERVBFLIMIT = 1000L;
    private static final long UPPERVBFLIMIT = 3000L;
    private static final float VBFLOW = 3.0f;
    private static final float VBFHIGH = 1.5f;
    private final boolean strong;

    public Cocoa(String tag, Configuration config, boolean strong) {
        super(tag, config);
        this.strong = strong;
        this.setDithering(true);
    }

    @Override
    protected RemoteEndpoint createRemoteEndpoint(InetSocketAddress remoteSocketAddress) {
        return new CocoaRemoteEndpoint(remoteSocketAddress, this.defaultReliabilityLayerParameters.getAckTimeout(), this.defaultReliabilityLayerParameters.getNstart(), this.strong);
    }

    @Override
    protected float calculateVBF(long rto, float scale) {
        if (rto > 3000L) {
            return 1.5f;
        }
        if (rto < 1000L) {
            return 3.0f;
        }
        return scale;
    }

    private static class CocoaRemoteEndpoint
    extends RemoteEndpoint {
        private final boolean onlyStrong;
        private Rto weakRto;
        private Rto strongRto;
        private long nanoTimestamp;

        private CocoaRemoteEndpoint(InetSocketAddress remoteAddress, int ackTimeout, int nstart, boolean strong) {
            super(remoteAddress, ackTimeout, nstart, true);
            this.onlyStrong = strong;
            this.weakRto = new Rto(1, ackTimeout);
            this.strongRto = new Rto(4, ackTimeout);
            this.nanoTimestamp = ClockUtil.nanoRealtime();
        }

        @Override
        public synchronized void processRttMeasurement(RemoteEndpoint.RtoType rtoType, long measuredRTT) {
            double weighting;
            long newRto;
            if (this.onlyStrong && rtoType != RemoteEndpoint.RtoType.STRONG) {
                return;
            }
            switch (rtoType) {
                case WEAK: {
                    newRto = this.weakRto.apply(measuredRTT);
                    weighting = 0.25;
                    break;
                }
                case STRONG: {
                    newRto = this.strongRto.apply(measuredRTT);
                    weighting = 0.5;
                    break;
                }
                default: {
                    return;
                }
            }
            newRto = Math.round(weighting * (double)newRto + (1.0 - weighting) * (double)this.getRTO());
            this.updateRTO(newRto);
            this.nanoTimestamp = ClockUtil.nanoRealtime();
        }

        @Override
        public synchronized void checkAging() {
            long overallDifference = this.getRtoAge(TimeUnit.MILLISECONDS);
            long rto = this.getRTO();
            while (true) {
                if (rto < 1000L && overallDifference > 16L * rto) {
                    overallDifference -= 16L * rto;
                    this.updateRTO(rto *= 2L);
                    this.nanoTimestamp = ClockUtil.nanoRealtime();
                    continue;
                }
                if (rto <= 3000L || overallDifference <= 4L * rto) break;
                overallDifference -= 4L * rto;
                rto = 1000L + rto / 2L;
                this.updateRTO(rto);
                this.nanoTimestamp = ClockUtil.nanoRealtime();
            }
        }

        private long getRtoAge(TimeUnit unit) {
            long nanos = ClockUtil.nanoRealtime() - this.nanoTimestamp;
            return unit.convert(nanos, TimeUnit.NANOSECONDS);
        }
    }
}

