/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.ContentType;
import org.eclipse.californium.scandium.dtls.DTLSMessage;
import org.eclipse.californium.scandium.dtls.HandshakeException;

public final class ChangeCipherSpecMessage
implements DTLSMessage {
    private static final int CCS_BITS = 8;
    private final CCSType CCSProtocolType = CCSType.CHANGE_CIPHER_SPEC;

    @Override
    public ContentType getContentType() {
        return ContentType.CHANGE_CIPHER_SPEC;
    }

    public CCSType getCCSProtocolType() {
        return this.CCSProtocolType;
    }

    @Override
    public String toString(int indent) {
        return StringUtil.indentation(indent) + "Change Cipher Spec Message" + StringUtil.lineSeparator();
    }

    public String toString() {
        return this.toString(0);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public byte[] toByteArray() {
        DatagramWriter writer = new DatagramWriter(1);
        writer.write(this.CCSProtocolType.getCode(), 8);
        return writer.toByteArray();
    }

    public static DTLSMessage fromByteArray(byte[] byteArray) throws HandshakeException {
        DatagramReader reader = new DatagramReader(byteArray);
        int code = reader.read(8);
        if (code == CCSType.CHANGE_CIPHER_SPEC.getCode()) {
            return new ChangeCipherSpecMessage();
        }
        String message = "Unknown Change Cipher Spec code received: " + code;
        AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER);
        throw new HandshakeException(message, alert);
    }

    public static enum CCSType {
        CHANGE_CIPHER_SPEC(1);

        private int code;

        private CCSType(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

