/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests.tests;

import org.eclipse.californium.core.coap.BlockOption;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.plugtests.TestClientAbstract;

public class CB01
extends TestClientAbstract {
    public final CoAP.ResponseCode EXPECTED_RESPONSE_CODE = CoAP.ResponseCode.CONTENT;

    public CB01(String serverURI) {
        super(CB01.class.getSimpleName());
        Request request = Request.newGet();
        request.getOptions().setBlock2(BlockOption.size2Szx(64), false, 0);
        this.executeRequest(request, serverURI, "/large");
    }

    @Override
    protected boolean checkResponse(Request request, Response response) {
        boolean success = response.getOptions().hasBlock2();
        if (!success) {
            System.out.println("FAIL: no Block2 option");
        } else {
            int maxNUM = response.getOptions().getBlock2().getNum();
            success &= this.checkType(CoAP.Type.ACK, response.getType());
            success &= this.checkCode(this.EXPECTED_RESPONSE_CODE, response.getCode());
            success &= this.checkOption(new BlockOption(2, false, maxNUM), response.getOptions().getBlock2(), "Block2");
            success &= this.hasNonEmptyPayload(response);
            success &= this.hasContentType(response);
        }
        return success;
    }
}

