/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium;

import java.net.DatagramPacket;
import org.eclipse.californium.scandium.DatagramFilter;
import org.eclipse.californium.scandium.dtls.ContentType;

public class DtlsDatagramFilter
implements DatagramFilter {
    @Override
    public boolean onReceiving(DatagramPacket packet) {
        int offset;
        if (packet.getLength() < 13) {
            return false;
        }
        byte[] data = packet.getData();
        ContentType contentType = ContentType.getTypeByValue(data[offset = packet.getOffset()]);
        if (contentType == null) {
            return false;
        }
        if (data[offset + 3] != 0 || (data[offset + 4] & 0xFF) > 1 || data[offset + 5] != 0) {
            return false;
        }
        if (contentType == ContentType.HANDSHAKE || contentType == ContentType.ALERT) {
            return true;
        }
        int major = 0xFF & data[offset + 1];
        int minor = 0xFF & data[offset + 2];
        return major == 254 && minor == 253;
    }
}

