/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.oscore;

import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.MessageObserverAdapter;
import org.eclipse.californium.core.coap.OptionSet;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.coap.Token;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.stack.AbstractLayer;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.oscore.CoapOSException;
import org.eclipse.californium.oscore.CoapOSExceptionHandler;
import org.eclipse.californium.oscore.ContextRederivation;
import org.eclipse.californium.oscore.OSCoreCtx;
import org.eclipse.californium.oscore.OSCoreCtxDB;
import org.eclipse.californium.oscore.OSCoreEndpointContextInfo;
import org.eclipse.californium.oscore.OSException;
import org.eclipse.californium.oscore.OscoreOptionDecoder;
import org.eclipse.californium.oscore.RequestDecryptor;
import org.eclipse.californium.oscore.RequestEncryptor;
import org.eclipse.californium.oscore.ResponseDecryptor;
import org.eclipse.californium.oscore.ResponseEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectSecurityLayer
extends AbstractLayer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjectSecurityLayer.class);
    private final OSCoreCtxDB ctxDb;

    public ObjectSecurityLayer(OSCoreCtxDB ctxDb) {
        if (ctxDb == null) {
            throw new NullPointerException("OSCoreCtxDB must be provided!");
        }
        this.ctxDb = ctxDb;
    }

    public static Request prepareSend(OSCoreCtxDB ctxDb, Request message) throws OSException {
        return RequestEncryptor.encrypt(ctxDb, message);
    }

    public static Response prepareSend(OSCoreCtxDB ctxDb, Response message, OSCoreCtx ctx, boolean newPartialIV, boolean outerBlockwise, int requestSequenceNr) throws OSException {
        return ResponseEncryptor.encrypt(ctxDb, message, ctx, newPartialIV, outerBlockwise, requestSequenceNr);
    }

    public static Request prepareReceive(OSCoreCtxDB ctxDb, Request request, OSCoreCtx ctx) throws CoapOSException {
        return RequestDecryptor.decrypt(ctxDb, request, ctx);
    }

    public static Response prepareReceive(OSCoreCtxDB ctxDb, Response response, int requestSequenceNr) throws OSException {
        return ResponseDecryptor.decrypt(ctxDb, response, requestSequenceNr);
    }

    @Override
    public void sendRequest(Exchange exchange, final Request request) {
        Request req = request;
        if (ObjectSecurityLayer.shouldProtectRequest(request)) {
            try {
                boolean outerBlockwise;
                boolean bl = outerBlockwise = request.getOptions().hasBlock2() && exchange.getCurrentResponse() != null && this.ctxDb.getContextByToken(exchange.getCurrentResponse().getToken()) != null;
                if (outerBlockwise) {
                    super.sendRequest(exchange, req);
                    return;
                }
                String uri = request.getOptions().hasProxyUri() ? request.getOptions().getProxyUri() : request.getURI();
                if (uri == null) {
                    LOGGER.error("URI is null");
                    throw new OSException("URI is null");
                }
                OSCoreCtx ctx = this.ctxDb.getContext(uri);
                if (ctx == null) {
                    LOGGER.error("Context is null");
                    throw new OSException("Context is null");
                }
                if (ctx.getContextRederivationPhase() == ContextRederivation.PHASE.CLIENT_INITIATE) {
                    throw new IllegalStateException("must be handled in ObjectSecurityContextLayer!");
                }
                OSCoreEndpointContextInfo.sendingRequest(ctx, exchange);
                final Request preparedRequest = ObjectSecurityLayer.prepareSend(this.ctxDb, request);
                final OSCoreCtx finalCtx = this.ctxDb.getContext(uri);
                if (this.outgoingExceedsMaxUnfragSize(preparedRequest, outerBlockwise, ctx.getMaxUnfragmentedSize())) {
                    throw new IllegalStateException("outgoing request is exceeding the MAX_UNFRAGMENTED_SIZE!");
                }
                preparedRequest.addMessageObserver(0, new MessageObserverAdapter(){

                    @Override
                    public void onReadyToSend() {
                        Token token = preparedRequest.getToken();
                        if (request.getToken() == null) {
                            request.setToken(token);
                        }
                        if (!request.hasMID() && preparedRequest.hasMID()) {
                            request.setMID(preparedRequest.getMID());
                        }
                        ObjectSecurityLayer.this.ctxDb.addContext(token, finalCtx);
                    }
                });
                req = preparedRequest;
                exchange.setCryptographicContextID(req.getOptions().getOscore());
            }
            catch (OSException e) {
                LOGGER.error("Error sending request: {}", (Object)e.getMessage());
                return;
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Unable to send request because of illegal argument: {}", (Object)e.getMessage());
                return;
            }
        }
        LOGGER.trace("Request: {}", (Object)exchange.getRequest());
        super.sendRequest(exchange, req);
    }

    @Override
    public void sendResponse(Exchange exchange, Response response) {
        if (ObjectSecurityLayer.shouldProtectResponse(exchange)) {
            boolean outerBlockwise = exchange.getCurrentRequest().getOptions().hasOscore() && exchange.getCurrentRequest().getOptions().getOscore().length != 0;
            try {
                OSCoreCtx ctx = this.ctxDb.getContextByToken(exchange.getCurrentRequest().getToken());
                boolean addPartialIV = ctx != null && ctx.getResponsesIncludePartialIV() || exchange.getRequest().getOptions().hasObserve();
                OscoreOptionDecoder optionDecoder = new OscoreOptionDecoder(exchange.getCryptographicContextID());
                int requestSequenceNumber = optionDecoder.getSequenceNumber();
                Response preparedResponse = ObjectSecurityLayer.prepareSend(this.ctxDb, response, ctx, addPartialIV, outerBlockwise, requestSequenceNumber);
                if (this.outgoingExceedsMaxUnfragSize(preparedResponse, outerBlockwise, ctx.getMaxUnfragmentedSize())) {
                    Response error = new Response(CoAP.ResponseCode.INTERNAL_SERVER_ERROR, true);
                    error.setDestinationContext(exchange.getCurrentRequest().getSourceContext());
                    super.sendResponse(exchange, error);
                    throw new IllegalStateException("outgoing response is exceeding the MAX_UNFRAGMENTED_SIZE!");
                }
                response = preparedResponse;
                exchange.setResponse(response);
            }
            catch (OSException e) {
                LOGGER.error("Error sending response: {}", (Object)e.getMessage());
                return;
            }
        }
        if (!response.getOptions().hasObserve() || exchange.getRequest().isObserveCancel()) {
            this.ctxDb.removeToken(exchange.getCurrentRequest().getToken());
        }
        super.sendResponse(exchange, response);
    }

    @Override
    public void sendEmptyMessage(Exchange exchange, EmptyMessage message) {
        super.sendEmptyMessage(exchange, message);
    }

    @Override
    public void receiveRequest(Exchange exchange, Request request) {
        if (ObjectSecurityLayer.isProtected(request)) {
            byte[] requestOscoreOption;
            OSCoreCtx ctx = null;
            try {
                OscoreOptionDecoder optionDecoder = new OscoreOptionDecoder(request.getOptions().getOscore());
                byte[] rid = optionDecoder.getKid();
                byte[] IDContext = optionDecoder.getIdContext();
                ctx = this.ctxDb.getContext(rid, IDContext);
            }
            catch (CoapOSException e) {
                LOGGER.error("Error while receiving OSCore request: {}", (Object)e.getMessage());
                Response error = CoapOSExceptionHandler.manageError(e, request);
                if (error != null) {
                    super.sendResponse(exchange, error);
                }
                return;
            }
            if (request.getOptions().hasBlock1()) {
                if (request.getMaxResourceBodySize() == 0) {
                    int maxPayloadSize = this.getIncomingMaxUnfragSize((Message)request, ctx);
                    request.setMaxResourceBodySize(maxPayloadSize);
                }
                super.receiveRequest(exchange, request);
                return;
            }
            try {
                requestOscoreOption = request.getOptions().getOscore();
                request = ObjectSecurityLayer.prepareReceive(this.ctxDb, request, ctx);
                request.getOptions().setOscore(Bytes.EMPTY);
                exchange.setRequest(request);
            }
            catch (CoapOSException e) {
                LOGGER.error("Error while receiving OSCore request: {}", (Object)e.getMessage());
                Response error = CoapOSExceptionHandler.manageError(e, request);
                if (error != null) {
                    super.sendResponse(exchange, error);
                }
                return;
            }
            exchange.setCryptographicContextID(requestOscoreOption);
        }
        super.receiveRequest(exchange, request);
    }

    @Override
    public void receiveResponse(Exchange exchange, Response response) {
        Request request = exchange.getCurrentRequest();
        if (request == null) {
            LOGGER.error("No request tied to this response");
            return;
        }
        try {
            boolean expectProtectedResponse = this.responseShouldBeProtected(exchange, response);
            if (!ObjectSecurityLayer.isProtected(response) && expectProtectedResponse) {
                LOGGER.info("Incoming response is NOT OSCORE protected but is expected to be!");
            } else if (ObjectSecurityLayer.isProtected(response) && expectProtectedResponse) {
                LOGGER.debug("Incoming response is OSCORE protected");
            } else if (ObjectSecurityLayer.isProtected(response)) {
                LOGGER.warn("Incoming response is OSCORE protected but it should not be");
            }
            if (response.getOptions().hasBlock2()) {
                if (response.getMaxResourceBodySize() == 0) {
                    int maxPayloadSize = this.getIncomingMaxUnfragSize((Message)response, this.ctxDb);
                    response.setMaxResourceBodySize(maxPayloadSize);
                }
                super.receiveResponse(exchange, response);
                return;
            }
            if (ObjectSecurityLayer.isProtected(response)) {
                OscoreOptionDecoder optionDecoder = new OscoreOptionDecoder(exchange.getCryptographicContextID());
                int requestSequenceNumber = optionDecoder.getSequenceNumber();
                response = ObjectSecurityLayer.prepareReceive(this.ctxDb, response, requestSequenceNumber);
            }
        }
        catch (OSException e) {
            LOGGER.error("Error while receiving OSCore response: {}", (Object)e.getMessage());
            EmptyMessage error = CoapOSExceptionHandler.manageError(e, response);
            if (error != null) {
                this.sendEmptyMessage(exchange, error);
            }
            return;
        }
        if (exchange.getRequest().isObserveCancel()) {
            this.ctxDb.removeToken(response.getToken());
        }
        super.receiveResponse(exchange, response);
    }

    @Override
    public void receiveEmptyMessage(Exchange exchange, EmptyMessage message) {
        super.receiveEmptyMessage(exchange, message);
    }

    private static boolean shouldProtectResponse(Exchange exchange) {
        return exchange.getCryptographicContextID() != null;
    }

    private boolean responseShouldBeProtected(Exchange exchange, Response response) throws OSException {
        Request request = exchange.getCurrentRequest();
        OptionSet options = request.getOptions();
        if (exchange.getCryptographicContextID() == null && response.getOptions().hasObserve() && request.getOptions().hasObserve() && options.hasOscore()) {
            exchange.setCryptographicContextID(options.getOscore());
        }
        return exchange.getCryptographicContextID() != null;
    }

    private static boolean shouldProtectRequest(Request request) {
        OptionSet options = request.getOptions();
        return options.hasOption(9);
    }

    private static boolean isProtected(Message message) {
        return message.getOptions().getOscore() != null;
    }

    private boolean outgoingExceedsMaxUnfragSize(Message message, boolean outerBlockwise, int maxUnfragmentedSize) {
        boolean usesInnerBlockwise;
        boolean bl = usesInnerBlockwise = (message.getOptions().hasBlock1() || message.getOptions().hasBlock2()) && !outerBlockwise;
        return message.getPayloadSize() > maxUnfragmentedSize && !usesInnerBlockwise;
    }

    private int getIncomingMaxUnfragSize(Message message, OSCoreCtx ctx) {
        if (ctx == null) {
            return 0;
        }
        return ctx.getMaxUnfragmentedSize();
    }

    private int getIncomingMaxUnfragSize(Message message, OSCoreCtxDB ctxDb) {
        OSCoreCtx ctx = null;
        if (message instanceof Response) {
            ctx = ctxDb.getContextByToken(message.getToken());
        }
        return this.getIncomingMaxUnfragSize(message, ctx);
    }
}

