/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.cose;

import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.californium.cose.AlgorithmID;
import org.eclipse.californium.cose.CoseException;
import org.eclipse.californium.cose.HeaderKeys;
import org.eclipse.californium.cose.Message;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.scandium.dtls.cipher.CCMBlockCipher;

public abstract class EncryptCommon
extends Message {
    private static final int AES_CCM_16_IV_LENGTH = 13;
    private static final int AES_CCM_64_IV_LENGTH = 7;
    protected String context;
    protected byte[] rgbEncrypt;

    protected byte[] decryptWithKey(byte[] rgbKey) throws CoseException {
        CBORObject algX = this.findAttribute(HeaderKeys.Algorithm);
        AlgorithmID alg = AlgorithmID.FromCBOR(algX);
        if (this.rgbEncrypt == null) {
            throw new CoseException("No Encrypted Content Specified");
        }
        if (!EncryptCommon.isSupportedAesCcm(alg)) {
            throw new CoseException("Unsupported Algorithm Specified");
        }
        this.AES_CCM_Decrypt(alg, rgbKey);
        return this.rgbContent;
    }

    void encryptWithKey(byte[] rgbKey) throws CoseException, IllegalStateException {
        CBORObject algX = this.findAttribute(HeaderKeys.Algorithm);
        AlgorithmID alg = AlgorithmID.FromCBOR(algX);
        if (this.rgbContent == null) {
            throw new CoseException("No Content Specified");
        }
        if (!EncryptCommon.isSupportedAesCcm(alg)) {
            throw new CoseException("Unsupported Algorithm Specified");
        }
        this.AES_CCM_Encrypt(alg, rgbKey);
    }

    private byte[] getAADBytes() {
        CBORObject obj = CBORObject.NewArray();
        obj.Add(this.context);
        if (this.objProtected.size() == 0) {
            obj.Add(CBORObject.FromObject(Bytes.EMPTY));
        } else {
            obj.Add(this.objProtected.EncodeToBytes());
        }
        obj.Add(CBORObject.FromObject(this.externalData));
        return obj.EncodeToBytes();
    }

    private void AES_CCM_Decrypt(AlgorithmID alg, byte[] rgbKey) throws CoseException, IllegalStateException {
        if (rgbKey.length != alg.getKeySize() / 8) {
            throw new CoseException("Key Size is incorrect");
        }
        int ivLen = EncryptCommon.ivLength(alg);
        CBORObject iv = this.findAttribute(HeaderKeys.IV);
        if (iv == null) {
            throw new CoseException("Missing IV during decryption");
        }
        if (iv.getType() != CBORType.ByteString) {
            throw new CoseException("IV is incorrectly formed");
        }
        if (iv.GetByteString().length != ivLen) {
            throw new CoseException("IV size is incorrect");
        }
        byte[] aad = this.getAADBytes();
        try {
            this.rgbContent = CCMBlockCipher.decrypt(new SecretKeySpec(rgbKey, "AES"), iv.GetByteString(), aad, this.getEncryptedContent(), alg.getTagSize() / 8);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CoseException("Algorithm not supported", ex);
        }
        catch (InvalidKeyException ex) {
            if (ex.getMessage().equals("Illegal key size")) {
                throw new CoseException("Unsupported key size", ex);
            }
            throw new CoseException("Decryption failure", ex);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CoseException("Decryption failure", ex);
        }
    }

    private void AES_CCM_Encrypt(AlgorithmID alg, byte[] rgbKey) throws CoseException, IllegalStateException {
        SecureRandom random = new SecureRandom();
        if (rgbKey.length != alg.getKeySize() / 8) {
            throw new CoseException("Key Size is incorrect");
        }
        CBORObject iv = this.findAttribute(HeaderKeys.IV);
        int ivLen = EncryptCommon.ivLength(alg);
        if (iv == null) {
            byte[] tmp = new byte[ivLen];
            random.nextBytes(tmp);
            iv = CBORObject.FromObject(tmp);
            this.addAttribute(HeaderKeys.IV, iv, 2);
        } else {
            if (iv.getType() != CBORType.ByteString) {
                throw new CoseException("IV is incorreclty formed.");
            }
            if (iv.GetByteString().length > ivLen) {
                throw new CoseException("IV is too long.");
            }
        }
        byte[] aad = this.getAADBytes();
        try {
            this.rgbEncrypt = CCMBlockCipher.encrypt(new SecretKeySpec(rgbKey, "AES"), iv.GetByteString(), aad, this.GetContent(), alg.getTagSize() / 8);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CoseException("Algorithm not supported", ex);
        }
        catch (Exception ex) {
            throw new CoseException("Encryption failure", ex);
        }
    }

    public byte[] getEncryptedContent() throws CoseException {
        if (this.rgbEncrypt == null) {
            throw new CoseException("No Encrypted Content Specified");
        }
        return this.rgbEncrypt;
    }

    public void setEncryptedContent(byte[] rgb) {
        this.rgbEncrypt = rgb;
    }

    public static int ivLength(AlgorithmID alg) {
        switch (alg) {
            case AES_CCM_16_64_128: 
            case AES_CCM_16_128_128: {
                return 13;
            }
            case AES_CCM_64_64_128: 
            case AES_CCM_64_128_128: {
                return 7;
            }
        }
        return -1;
    }

    public static boolean isSupportedAesCcm(AlgorithmID alg) {
        return EncryptCommon.ivLength(alg) != -1;
    }
}

