/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests.tests;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.core.Utils;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.plugtests.TestClientAbstract;

public class CO09
extends TestClientAbstract {
    private static final String RESOURCE_URI = "/obs";
    private final CoAP.ResponseCode EXPECTED_RESPONSE_CODE = CoAP.ResponseCode.CONTENT;
    private final CoAP.ResponseCode EXPECTED_RESPONSE_CODE_1 = CoAP.ResponseCode.CHANGED;
    private int contentType = 0;
    private String newValue = "New value";

    public CO09(String serverURI) {
        super(CO09.class.getSimpleName());
        Request request = new Request(CoAP.Code.GET, CoAP.Type.CON);
        request.setObserve();
        this.executeRequest(request, serverURI, RESOURCE_URI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void executeRequest(Request request, String serverURI, String resourceUri) {
        if (!serverURI.endsWith("/") && !resourceUri.startsWith("/")) {
            resourceUri = "/" + resourceUri;
        }
        URI uri = null;
        try {
            uri = new URI(serverURI + resourceUri);
            this.setUseTcp(uri.getScheme());
        }
        catch (URISyntaxException use) {
            throw new IllegalArgumentException("Invalid URI: " + use.getMessage());
        }
        CO09.addContextObserver(request);
        request.setURI(uri);
        int observeLoop = 2;
        if (this.verbose) {
            System.out.println("Request for test " + this.testName + " sent");
            Utils.prettyPrint(request);
        }
        try {
            Response response = null;
            boolean success = true;
            this.startObserve(request);
            System.out.println();
            System.out.println("**** TEST: " + this.testName + " ****");
            System.out.println("**** BEGIN CHECK ****");
            response = request.waitForResponse(6000L);
            if (response != null) {
                success &= this.checkCode(this.EXPECTED_RESPONSE_CODE, response.getCode());
                success &= this.checkType(CoAP.Type.ACK, response.getType());
                success &= this.hasContentType(response);
                success &= this.hasToken(response);
                success &= this.hasObserve(response);
            } else {
                System.out.println("FAIL: No notification after registration");
                success = false;
            }
            for (int l = 0; success && l < observeLoop; ++l) {
                response = this.waitForNotification(6000L);
                if (response != null) {
                    System.out.println("Received notification " + l);
                    if (this.verbose) {
                        System.out.println("Response received");
                        System.out.println("Time elapsed (ms): " + TimeUnit.NANOSECONDS.toMillis(response.getApplicationRttNanos()));
                        Utils.prettyPrint(response);
                    }
                    success &= this.checkResponse(request, response);
                    if (this.hasObserve(response)) continue;
                    break;
                }
                System.out.println("FAIL: missing notification");
                success = false;
            }
            System.out.println("+++++ Sending PUT +++++");
            Request asyncRequest = new Request(CoAP.Code.PUT, CoAP.Type.CON);
            CO09.addContextObserver(asyncRequest);
            asyncRequest.setPayload(this.newValue);
            asyncRequest.getOptions().setContentFormat(this.contentType);
            asyncRequest.setURI(uri);
            asyncRequest.send();
            response = asyncRequest.waitForResponse(6000L);
            if (response != null) {
                success &= this.checkCode(this.EXPECTED_RESPONSE_CODE_1, response.getCode());
            } else {
                System.out.println("FAIL: missing response");
                success = false;
            }
            response = this.waitForNotification(6000L);
            if (response != null) {
                success &= this.checkCode(this.EXPECTED_RESPONSE_CODE, response.getCode());
                success &= this.hasObserve(response);
                success &= this.hasContentType(response);
                success &= this.hasToken(response);
                success &= this.checkString(this.newValue, response.getPayloadString(), "payload");
            } else {
                System.out.println("FAIL: missing notification after PUT");
                success = false;
            }
            if (success) {
                System.out.println("**** TEST PASSED ****");
                this.addSummaryEntry(this.testName + ": PASSED");
            } else {
                System.out.println("**** TEST FAILED ****");
                this.addSummaryEntry(this.testName + ": --FAILED--");
            }
            this.tickOffTest();
        }
        catch (InterruptedException e) {
            System.err.println("Interupted during receive: " + e.getMessage());
            System.exit(-1);
        }
        finally {
            this.stopObservation();
        }
    }

    @Override
    protected boolean checkResponse(Request request, Response response) {
        boolean success = true;
        success &= this.checkType(CoAP.Type.CON, response.getType());
        success &= this.checkCode(this.EXPECTED_RESPONSE_CODE, response.getCode());
        success &= this.checkToken(request.getToken(), response.getToken());
        success &= this.hasContentType(response);
        success &= this.hasNonEmptyPayload(response);
        return success &= this.hasObserve(response);
    }
}

