/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests.tests;

import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.plugtests.TestClientAbstract;

public class CL06
extends TestClientAbstract {
    public static final String RESOURCE_URI = "/.well-known/core";
    public final CoAP.ResponseCode EXPECTED_RESPONSE_CODE = CoAP.ResponseCode.CONTENT;
    public static final String EXPECTED_SZ = "sz=*";

    public CL06(String serverURI) {
        super(CL06.class.getSimpleName());
        Request request = new Request(CoAP.Code.GET, CoAP.Type.CON);
        this.executeRequest(request, serverURI, "/.well-known/core?sz=*");
    }

    @Override
    protected boolean checkResponse(Request request, Response response) {
        boolean success = true;
        success &= this.checkType(CoAP.Type.ACK, response.getType());
        success &= this.checkCode(this.EXPECTED_RESPONSE_CODE, response.getCode());
        success &= this.checkOption(40, response.getOptions().getContentFormat(), "Content-Format");
        success &= this.hasNonEmptyPayload(response);
        return success &= this.checkDiscoveryAttributes(EXPECTED_SZ, response.getPayloadString());
    }
}

