/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests.tests;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.cli.decoder.CborDecoder;
import org.eclipse.californium.cli.decoder.Decoder;
import org.eclipse.californium.cli.decoder.JsonDecoder;
import org.eclipse.californium.core.Utils;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.plugtests.TestClientAbstract;

public class CC20
extends TestClientAbstract {
    public static final String RESOURCE_URI = "/multi-format";
    public final CoAP.ResponseCode EXPECTED_RESPONSE_CODE = CoAP.ResponseCode.CONTENT;

    public CC20(String serverURI) {
        super(CC20.class.getSimpleName());
        Request request = new Request(CoAP.Code.GET, CoAP.Type.CON);
        request.getOptions().setAccept(0);
        this.executeRequest(request, serverURI, RESOURCE_URI);
    }

    @Override
    protected synchronized void executeRequest(Request request, String serverURI, String resourceUri) {
        if (!serverURI.endsWith("/") && !resourceUri.startsWith("/")) {
            resourceUri = "/" + resourceUri;
        }
        URI uri = null;
        try {
            uri = new URI(serverURI + resourceUri);
            this.setUseTcp(uri.getScheme());
        }
        catch (URISyntaxException use) {
            throw new IllegalArgumentException("Invalid URI: " + use.getMessage());
        }
        CC20.addContextObserver(request);
        request.setURI(uri);
        if (this.verbose) {
            System.out.println("Request for test " + this.testName + " sent");
            Utils.prettyPrint(request);
        }
        try {
            System.out.println();
            System.out.println("**** TEST: " + this.testName + " ****");
            System.out.println("**** BEGIN CHECK ****");
            boolean success = this.executeRequest(request, 0, null);
            if (success) {
                request = new Request(CoAP.Code.GET, CoAP.Type.CON);
                CC20.addContextObserver(request);
                request.setURI(uri);
                success = this.executeRequest(request, 41, null);
            }
            if (success) {
                request = new Request(CoAP.Code.GET, CoAP.Type.CON);
                CC20.addContextObserver(request);
                request.setURI(uri);
                success = this.executeRequest(request, 50, new JsonDecoder());
            }
            if (success) {
                request = new Request(CoAP.Code.GET, CoAP.Type.CON);
                CC20.addContextObserver(request);
                request.setURI(uri);
                success = this.executeRequest(request, 60, new CborDecoder());
            }
            if (success) {
                System.out.println("**** TEST PASSED ****");
                this.addSummaryEntry(this.testName + ": PASSED");
            } else {
                System.out.println("**** TEST FAILED ****");
                this.addSummaryEntry(this.testName + ": --FAILED--");
            }
            this.tickOffTest();
        }
        catch (InterruptedException e) {
            System.err.println("Interupted during receive: " + e.getMessage());
            System.exit(-1);
        }
    }

    private boolean executeRequest(Request request, int contentType, Decoder decoder) throws InterruptedException {
        Response response = null;
        boolean success = true;
        request.getOptions().setAccept(contentType);
        request.send();
        response = request.waitForResponse(6000L);
        if (response != null) {
            if (this.verbose) {
                System.out.println("Response received");
                System.out.println("Time elapsed (ms): " + TimeUnit.NANOSECONDS.toMillis(response.getApplicationRttNanos()));
                Utils.prettyPrint(response);
            }
            success &= this.checkType(CoAP.Type.ACK, response.getType());
            success &= this.checkCode(this.EXPECTED_RESPONSE_CODE, response.getCode());
            success &= this.checkOption(contentType, response.getOptions().getContentFormat(), "Content-Format");
            success &= this.hasNonEmptyPayload(response);
            if (decoder != null) {
                String decoded = decoder.decode(response.getPayload());
                System.out.println("Response decoded: " + decoded);
            }
        }
        return success;
    }

    @Override
    protected boolean checkResponse(Request request, Response response) {
        return false;
    }
}

