/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.config;

import java.util.concurrent.TimeUnit;
import org.eclipse.californium.elements.config.DocumentedDefinition;
import org.eclipse.californium.elements.config.ValueException;

public class TimeDefinition
extends DocumentedDefinition<Long> {
    public TimeDefinition(String key, String documentation) {
        super(key, documentation, Long.class, null);
    }

    public TimeDefinition(String key, String documentation, long defaultValue, TimeUnit unit) {
        super(key, documentation, Long.class, TimeUnit.NANOSECONDS.convert(defaultValue, unit));
    }

    @Override
    public String getTypeName() {
        return "Time";
    }

    @Override
    public String writeValue(Long value) {
        TimeUnit unit = TimeUnit.MILLISECONDS;
        if (value != 0L) {
            unit = TimeUnit.NANOSECONDS;
            if (value % 1000L == 0L) {
                unit = TimeUnit.MICROSECONDS;
                if ((value = Long.valueOf(value / 1000L)) % 1000L == 0L) {
                    unit = TimeUnit.MILLISECONDS;
                    if ((value = Long.valueOf(value / 1000L)) % 1000L == 0L) {
                        unit = TimeUnit.SECONDS;
                        if ((value = Long.valueOf(value / 1000L)) % 60L == 0L) {
                            unit = TimeUnit.MINUTES;
                            if ((value = Long.valueOf(value / 60L)) % 60L == 0L) {
                                unit = TimeUnit.HOURS;
                                if ((value = Long.valueOf(value / 60L)) % 24L == 0L) {
                                    unit = TimeUnit.DAYS;
                                    value = value / 24L;
                                }
                            }
                        }
                    }
                }
            }
        }
        return value + "[" + TimeDefinition.getTimeUnitAsText(unit) + "]";
    }

    @Override
    public Long checkValue(Long value) throws ValueException {
        if (value != null && value < 0L) {
            throw new ValueException("Time " + value + " must be not less than 0!");
        }
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Long parseValue(String value) throws ValueException {
        TimeUnit valueUnit = TimeUnit.MILLISECONDS;
        String num = value;
        int pos = value.indexOf(91);
        if (pos >= 0) {
            int end = value.indexOf(93);
            if (pos >= end) throw new ValueException(value + " doesn't match value[unit]!");
            num = value.substring(0, pos).trim();
            String textUnit = value.substring(pos + 1, end).trim();
            valueUnit = TimeDefinition.getTimeUnit(textUnit);
            if (valueUnit == null) {
                throw new ValueException(textUnit + " unknown unit!");
            }
        } else {
            TimeUnit unit;
            char last = value.charAt(value.length() - 1);
            if (!Character.isDigit(last) && (unit = TimeDefinition.getTimeUnit(value)) != null) {
                valueUnit = unit;
                num = value.substring(0, value.length() - TimeDefinition.getTimeUnitAsText(unit).length()).trim();
            }
        }
        long time = Long.parseLong(num);
        return TimeUnit.NANOSECONDS.convert(time, valueUnit);
    }

    public static String getTimeUnitAsText(TimeUnit unit) {
        switch (unit) {
            case NANOSECONDS: {
                return "ns";
            }
            case MICROSECONDS: {
                return "ys";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case SECONDS: {
                return "s";
            }
            case MINUTES: {
                return "min";
            }
            case HOURS: {
                return "h";
            }
            case DAYS: {
                return "d";
            }
        }
        return "";
    }

    public static TimeUnit getTimeUnit(String timeUnitText) {
        String matchUnitText = "";
        TimeUnit matchingUnit = null;
        for (TimeUnit unit : TimeUnit.values()) {
            String text = TimeDefinition.getTimeUnitAsText(unit);
            if (text.isEmpty()) continue;
            if (text.equals(timeUnitText)) {
                return unit;
            }
            if (!timeUnitText.endsWith(text) || text.length() <= matchUnitText.length()) continue;
            matchingUnit = unit;
            matchUnitText = text;
        }
        return matchingUnit;
    }
}

