/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.californium.elements.Definition;

public class Definitions<T extends Definition<?>>
implements Iterable<T> {
    private final String name;
    private final ConcurrentMap<String, T> definitions = new ConcurrentHashMap<String, T>();

    public Definitions(String name) {
        this.name = name;
    }

    public Definitions(Definitions<T> definitions) {
        this(definitions.getName(), definitions);
    }

    public Definitions(String name, Definitions<T> definitions) {
        this.name = name;
        this.definitions.putAll(definitions.definitions);
    }

    public String getName() {
        return this.name;
    }

    public Definitions<T> add(T definition) {
        T previous = this.addIfAbsent(definition);
        if (previous != null && previous != definition) {
            throw new IllegalArgumentException(this.name + " already contains " + ((Definition)definition).getKey() + "!");
        }
        return this;
    }

    public T addIfAbsent(T definition) {
        if (definition == null) {
            throw new NullPointerException();
        }
        return (T)((Definition)this.definitions.putIfAbsent(((Definition)definition).getKey(), definition));
    }

    public boolean contains(T definition) {
        T contained = this.get(((Definition)definition).getKey());
        return definition == contained;
    }

    public T get(String key) {
        return (T)((Definition)this.definitions.get(key));
    }

    @Override
    public Iterator<T> iterator() {
        return this.definitions.values().iterator();
    }
}

