/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.util;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.util.ServerName;

public final class ServerNames
implements Iterable<ServerName> {
    public static final int LIST_LENGTH_BITS = 16;
    public static final int NAME_LENGTH_BITS = 16;
    private final Set<ServerName> names = new LinkedHashSet<ServerName>();

    private ServerNames() {
    }

    private ServerNames(ServerName serverName) {
        this();
        this.add(serverName);
    }

    public static ServerNames newInstance() {
        return new ServerNames();
    }

    public static ServerNames newInstance(ServerName serverName) {
        if (serverName == null) {
            throw new NullPointerException("server name must not be null");
        }
        return new ServerNames(serverName);
    }

    public static ServerNames newInstance(String hostName) {
        if (hostName == null) {
            throw new NullPointerException("host name must not be null");
        }
        return new ServerNames(ServerName.from(ServerName.NameType.HOST_NAME, hostName.getBytes(ServerName.CHARSET)));
    }

    public ServerNames add(ServerName serverName) {
        if (serverName == null) {
            throw new NullPointerException("server name must not be null");
        }
        if (this.getServerName(serverName.getType()) != null) {
            throw new IllegalArgumentException("there is already a name of the given type");
        }
        this.names.add(serverName);
        return this;
    }

    public int getLength() {
        return this.getServerNamesLength() + 2;
    }

    public int getServerNamesLength() {
        int length = 0;
        for (ServerName serverName : this.names) {
            length += 3;
            length += serverName.getLength();
        }
        return length;
    }

    public int size() {
        return this.names.size();
    }

    public byte[] get(ServerName.NameType type) {
        ServerName serverName = this.getServerName(type);
        return serverName == null ? null : serverName.getName();
    }

    public void encode(DatagramWriter writer) {
        writer.write(this.getServerNamesLength(), 16);
        for (ServerName serverName : this.names) {
            writer.writeByte(serverName.getType().getCode());
            writer.writeVarBytes(serverName.getName(), 16);
        }
    }

    public void decode(DatagramReader reader) {
        int listLengthBytes = reader.read(16);
        DatagramReader rangeReader = reader.createRangeReader(listLengthBytes);
        block3: while (rangeReader.bytesAvailable()) {
            ServerName.NameType nameType = ServerName.NameType.fromCode(rangeReader.readNextByte());
            switch (nameType) {
                case HOST_NAME: {
                    byte[] hostname = rangeReader.readVarBytes(16);
                    this.add(ServerName.from(nameType, hostname));
                    continue block3;
                }
            }
            throw new IllegalArgumentException("ServerNames: unknown name_type!", new IllegalArgumentException(nameType.name()));
        }
    }

    public ServerName getServerName(ServerName.NameType type) {
        for (ServerName serverName : this.names) {
            if (!serverName.getType().equals((Object)type)) continue;
            return serverName;
        }
        return null;
    }

    @Override
    public Iterator<ServerName> iterator() {
        return this.names.iterator();
    }

    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        String indentation = StringUtil.indentation(indent + 1);
        sb.append(indentation).append("Server Names[").append(this.size()).append(" entries");
        for (ServerName serverName : this) {
            sb.append(", '").append(serverName.getNameAsString()).append("' (").append((Object)serverName.getType()).append(")");
        }
        sb.append("]");
        return sb.toString();
    }

    public String toString() {
        return this.toString(0);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        for (ServerName name : this.names) {
            result = 31 * result + name.hashCode();
        }
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ServerNames other = (ServerNames)object;
        if (this.names.size() != other.names.size()) {
            return false;
        }
        return this.names.containsAll(other.names);
    }

    public static boolean equalsIgnoreCase(String hostnameA, String hostnameB) {
        if (hostnameA == hostnameB) {
            return true;
        }
        if (hostnameA == null || hostnameB == null) {
            return false;
        }
        return hostnameA.equalsIgnoreCase(hostnameB);
    }
}

