/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.cli.ClientBaseConfig;
import org.eclipse.californium.cli.ClientInitializer;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Token;
import org.eclipse.californium.core.config.CoapConfig;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.config.SystemConfig;
import org.eclipse.californium.plugtests.Catalog;
import org.eclipse.californium.plugtests.Report;
import org.eclipse.californium.plugtests.TestClientAbstract;
import org.eclipse.californium.scandium.config.DtlsConfig;
import picocli.CommandLine;

public class PlugtestChecker {
    private static final File CONFIG_FILE = new File("CaliforniumPlugtest3.properties");
    private static final String CONFIG_HEADER = "Californium CoAP Properties file for Plugtest Client";
    private static final int DEFAULT_MAX_RESOURCE_SIZE = 8192;
    private static final int DEFAULT_BLOCK_SIZE = 64;
    public static final int PLUGTEST_BLOCK_SZX = 2;
    private static Configuration.DefinitionsProvider DEFAULTS = new Configuration.DefinitionsProvider(){

        @Override
        public void applyDefinitions(Configuration config) {
            config.set(SystemConfig.HEALTH_STATUS_INTERVAL, 300, TimeUnit.SECONDS);
            config.set(CoapConfig.MAX_RESOURCE_BODY_SIZE, 8192);
            config.set(CoapConfig.MAX_MESSAGE_SIZE, 64);
            config.set(CoapConfig.PREFERRED_BLOCK_SIZE, 64);
            config.set(CoapConfig.NOTIFICATION_CHECK_INTERVAL_COUNT, 4);
            config.set(CoapConfig.NOTIFICATION_CHECK_INTERVAL_TIME, 30, TimeUnit.SECONDS);
            config.set(CoapConfig.MAX_ACTIVE_PEERS, 10);
            config.set(CoapConfig.TCP_NUMBER_OF_BULK_BLOCKS, 1);
            config.set(DtlsConfig.DTLS_AUTO_HANDSHAKE_TIMEOUT, null, TimeUnit.SECONDS);
            config.set(DtlsConfig.DTLS_CONNECTION_ID_LENGTH, 0);
            config.set(DtlsConfig.DTLS_MAX_CONNECTIONS, 10);
        }
    };
    static volatile boolean verbose;
    private String serverURI = null;

    public PlugtestChecker(String serverURI) {
        if (serverURI == null || serverURI.isEmpty()) {
            throw new IllegalArgumentException("No server URI given");
        }
        this.serverURI = serverURI;
    }

    public void instantiateTests(List<String> testNames) {
        Catalog catalog = new Catalog();
        try {
            List<Class<?>> tests = catalog.getTestsClasses(testNames);
            if (tests.isEmpty()) {
                System.out.println("No matching TESTs found!");
                return;
            }
            if (testNames != null && !testNames.isEmpty()) {
                System.out.println("Tests:");
                ArrayList<String> names = new ArrayList<String>(tests.size());
                for (Class<?> test : tests) {
                    names.add(test.getSimpleName());
                }
                ClientInitializer.print("   ", 60, names, System.out);
            }
            ArrayList<Report> reports = new ArrayList<Report>();
            for (Class<?> testClass : tests) {
                System.out.println("Initialize test " + testClass);
                Constructor<?> cons = testClass.getConstructor(String.class);
                TestClientAbstract testClient = (TestClientAbstract)cons.newInstance(this.serverURI);
                try {
                    testClient.waitForUntilTestHasTerminated();
                }
                catch (Throwable e) {
                    System.err.println("Error: " + e.getMessage());
                    break;
                }
                reports.add(testClient.getReport());
            }
            if (!reports.isEmpty()) {
                System.out.println("\n==== SUMMARY ====");
                for (Report report : reports) {
                    report.print();
                }
            }
        }
        catch (InstantiationException e) {
            System.err.println("Reflection error");
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            System.err.println("Reflection error");
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            System.err.println("Reflection error");
            e.printStackTrace();
        }
        catch (SecurityException e) {
            System.err.println("Reflection error");
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            System.err.println("Reflection error");
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            System.err.println("Reflection error");
            e.printStackTrace();
        }
    }

    public synchronized void tickOffTest() {
        this.notify();
    }

    public static void main(String[] args) throws IOException {
        Config clientConfig = new Config();
        clientConfig.configurationHeader = CONFIG_HEADER;
        clientConfig.customConfigurationDefaultsProvider = DEFAULTS;
        clientConfig.configurationFile = CONFIG_FILE;
        ClientInitializer.init(args, clientConfig);
        if (clientConfig.helpRequested) {
            Catalog catalog = new Catalog();
            System.out.println("Available tests:");
            ClientInitializer.print("   ", 60, catalog.getAllTestNames(), System.out);
            System.exit(0);
        }
        verbose = clientConfig.verbose;
        if (clientConfig.tcp) {
            clientConfig.ping = false;
        } else if (clientConfig.secure && clientConfig.configuration.get(CoapConfig.RESPONSE_MATCHING) == CoapConfig.MatcherMode.PRINCIPAL_IDENTITY) {
            clientConfig.ping = true;
        }
        if (clientConfig.ping) {
            System.out.println("===============\nCC31\n---------------");
            try {
                if (PlugtestChecker.ping(clientConfig.uri)) {
                    System.out.println("PASS: " + clientConfig.uri + " responds to ping");
                } else {
                    System.out.println("FAIL:" + clientConfig.uri + " does not respond to ping, exiting...");
                    System.exit(-1);
                }
            }
            catch (Throwable ex) {
                System.err.println("Error: " + clientConfig.uri + " - " + ex.getMessage());
                System.exit(-1);
            }
        }
        PlugtestChecker clientFactory = new PlugtestChecker(clientConfig.uri);
        clientFactory.instantiateTests(clientConfig.tests);
        System.exit(0);
    }

    private static boolean ping(String address) throws Throwable {
        Request request = new Request(null);
        request.setType(CoAP.Type.CON);
        request.setToken(Token.EMPTY);
        request.setURI(address);
        TestClientAbstract.addContextObserver(request);
        System.out.println("++++++ Sending Ping ++++++");
        request.send().waitForResponse(5000L);
        Throwable sendError = request.getSendError();
        if (sendError != null) {
            throw sendError;
        }
        return request.isRejected();
    }

    public static String getLargeRequestPayload() {
        return "/-------------------------------------------------------------\\\n" + "|                  Request BLOCK NO. 1 OF 5                   |\n" + "|               [each line contains 64 bytes]                 |\n" + "\\-------------------------------------------------------------/\n" + "/-------------------------------------------------------------\\\n" + "|                  Request BLOCK NO. 2 OF 5                   |\n" + "|               [each line contains 64 bytes]                 |\n" + "\\-------------------------------------------------------------/\n" + "/-------------------------------------------------------------\\\n" + "|                  Request BLOCK NO. 3 OF 5                   |\n" + "|               [each line contains 64 bytes]                 |\n" + "\\-------------------------------------------------------------/\n" + "/-------------------------------------------------------------\\\n" + "|                  Request BLOCK NO. 4 OF 5                   |\n" + "|               [each line contains 64 bytes]                 |\n" + "\\-------------------------------------------------------------/\n" + "/-------------------------------------------------------------\\\n" + "|                  Request BLOCK NO. 5 OF 5                   |\n" + "|               [each line contains 64 bytes]                 |\n" + "\\-------------------------------------------------------------/\n";
    }

    @CommandLine.Command(name="PlugtestChecker", version={"(c) 2014, Institute for Pervasive Computing, ETH Zurich."})
    private static class Config
    extends ClientBaseConfig {
        @CommandLine.Option(names={"--no-ping"}, negatable=true, description={"use ping."})
        public boolean ping = true;
        @CommandLine.Option(names={"--tests"}, paramLabel="TESTs", split=",", description={"TESTs"})
        public List<String> tests;

        private Config() {
        }
    }
}

