/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.numbers;

import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.ERational;

final class ERationalCharArrayString {
    private static final int MaxSafeInt = 0xCCCCCCB;

    private ERationalCharArrayString() {
    }

    public static ERational FromString(char[] chars, int offset, int length, boolean throwException) {
        int tmpoffset = offset;
        if (chars == null) {
            if (!throwException) {
                return null;
            }
            throw new NullPointerException("chars");
        }
        if (tmpoffset < 0) {
            if (!throwException) {
                return null;
            }
            throw new NumberFormatException("offset(" + tmpoffset + ") is less than 0");
        }
        if (tmpoffset > chars.length) {
            if (!throwException) {
                return null;
            }
            throw new NumberFormatException("offset(" + tmpoffset + ") is more than " + chars.length);
        }
        if (length < 0) {
            if (!throwException) {
                return null;
            }
            throw new NumberFormatException("length(" + length + ") is less than 0");
        }
        if (length > chars.length) {
            if (!throwException) {
                return null;
            }
            throw new NumberFormatException("length(" + length + ") is more than " + chars.length);
        }
        if (chars.length - tmpoffset < length) {
            if (!throwException) {
                return null;
            }
            throw new NumberFormatException("chars's length minus " + tmpoffset + "(" + (chars.length - tmpoffset) + ") is less than " + length);
        }
        if (length == 0) {
            if (!throwException) {
                return null;
            }
            throw new NumberFormatException();
        }
        boolean negative = false;
        int endStr = tmpoffset + length;
        if (chars[tmpoffset] == '+' || chars[tmpoffset] == '-') {
            negative = chars[tmpoffset] == '-';
            ++tmpoffset;
        }
        int numerInt = 0;
        EInteger numer = null;
        boolean haveDigits = false;
        boolean haveDenominator = false;
        int ndenomInt = 0;
        EInteger ndenom = null;
        int i = tmpoffset;
        if (!(i + 8 != endStr || chars[i] != 'I' && chars[i] != 'i' || chars[i + 1] != 'N' && chars[i + 1] != 'n' || chars[i + 2] != 'F' && chars[i + 2] != 'f' || chars[i + 3] != 'I' && chars[i + 3] != 'i' || chars[i + 4] != 'N' && chars[i + 4] != 'n' || chars[i + 5] != 'I' && chars[i + 5] != 'i' || chars[i + 6] != 'T' && chars[i + 6] != 't' || chars[i + 7] != 'Y' && chars[i + 7] != 'y')) {
            return negative ? ERational.NegativeInfinity : ERational.PositiveInfinity;
        }
        if (!(i + 3 != endStr || chars[i] != 'I' && chars[i] != 'i' || chars[i + 1] != 'N' && chars[i + 1] != 'n' || chars[i + 2] != 'F' && chars[i + 2] != 'f')) {
            return negative ? ERational.NegativeInfinity : ERational.PositiveInfinity;
        }
        int numerStart = 0;
        if (!(i + 3 > endStr || chars[i] != 'N' && chars[i] != 'n' || chars[i + 1] != 'A' && chars[i + 1] != 'a' || chars[i + 2] != 'N' && chars[i + 2] != 'n')) {
            if (i + 3 == endStr) {
                return !negative ? ERational.NaN : ERational.NaN.Negate();
            }
            numerStart = i += 3;
            while (i < endStr) {
                if (chars[i] >= '0' && chars[i] <= '9') {
                    int thisdigit = chars[i] - 48;
                    if (numerInt <= 0xCCCCCCB) {
                        numerInt *= 10;
                        numerInt += thisdigit;
                    }
                } else {
                    if (!throwException) {
                        return null;
                    }
                    throw new NumberFormatException();
                }
                ++i;
            }
            if (numerInt > 0xCCCCCCB) {
                numer = EInteger.FromSubstring(chars, numerStart, endStr);
                return ERational.CreateNaN(numer, false, negative);
            }
            return ERational.CreateNaN(EInteger.FromInt32(numerInt), false, negative);
        }
        if (!(i + 4 > endStr || chars[i] != 'S' && chars[i] != 's' || chars[i + 1] != 'N' && chars[i + 1] != 'n' || chars[i + 2] != 'A' && chars[i + 2] != 'a' || chars[i + 3] != 'N' && chars[i + 3] != 'n')) {
            if (i + 4 == endStr) {
                return !negative ? ERational.SignalingNaN : ERational.SignalingNaN.Negate();
            }
            numerStart = i += 4;
            while (i < endStr) {
                if (chars[i] >= '0' && chars[i] <= '9') {
                    int thisdigit = chars[i] - 48;
                    boolean bl = haveDigits = haveDigits || thisdigit != 0;
                    if (numerInt <= 0xCCCCCCB) {
                        numerInt *= 10;
                        numerInt += thisdigit;
                    }
                } else {
                    if (!throwException) {
                        return null;
                    }
                    throw new NumberFormatException();
                }
                ++i;
            }
            int flags3 = (negative ? 1 : 0) | 8;
            if (numerInt > 0xCCCCCCB) {
                numer = EInteger.FromSubstring(chars, numerStart, endStr);
                return ERational.CreateNaN(numer, true, negative);
            }
            return ERational.CreateNaN(EInteger.FromInt32(numerInt), true, negative);
        }
        numerStart = i;
        int numerEnd = i;
        while (i < endStr) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                int thisdigit = chars[i] - 48;
                numerEnd = i + 1;
                if (numerInt <= 0xCCCCCCB) {
                    numerInt *= 10;
                    numerInt += thisdigit;
                }
            } else {
                if (chars[i] == '/') {
                    haveDenominator = true;
                    ++i;
                    break;
                }
                if (!throwException) {
                    return null;
                }
                throw new NumberFormatException();
            }
            haveDigits = true;
            ++i;
        }
        if (!haveDigits) {
            if (!throwException) {
                return null;
            }
            throw new NumberFormatException();
        }
        if (numerInt > 0xCCCCCCB) {
            numer = EInteger.FromSubstring(chars, numerStart, numerEnd);
        }
        if (haveDenominator) {
            EInteger denom = null;
            int denomInt = 0;
            tmpoffset = 1;
            haveDigits = false;
            if (i == endStr) {
                if (!throwException) {
                    return null;
                }
                throw new NumberFormatException();
            }
            numerStart = i;
            while (i < endStr) {
                if (chars[i] >= '0' && chars[i] <= '9') {
                    haveDigits = true;
                    int thisdigit = chars[i] - 48;
                    numerEnd = i + 1;
                    if (denomInt <= 0xCCCCCCB) {
                        denomInt *= 10;
                        denomInt += thisdigit;
                    }
                } else {
                    if (!throwException) {
                        return null;
                    }
                    throw new NumberFormatException();
                }
                ++i;
            }
            if (!haveDigits) {
                if (!throwException) {
                    return null;
                }
                throw new NumberFormatException();
            }
            if (denomInt > 0xCCCCCCB) {
                denom = EInteger.FromSubstring(chars, numerStart, numerEnd);
            }
            if (denom == null) {
                ndenomInt = denomInt;
            } else {
                ndenom = denom;
            }
        } else {
            ndenomInt = 1;
        }
        if (i != endStr) {
            if (!throwException) {
                return null;
            }
            throw new NumberFormatException();
        }
        if (ndenom == null ? ndenomInt == 0 : ndenom.isZero()) {
            if (!throwException) {
                return null;
            }
            throw new NumberFormatException();
        }
        ERational erat = ERational.Create(numer == null ? EInteger.FromInt32(numerInt) : numer, ndenom == null ? EInteger.FromInt32(ndenomInt) : ndenom);
        return negative ? erat.Negate() : erat;
    }
}

