/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests.tests;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.californium.core.Utils;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.plugtests.TestClientAbstract;

public class CC16
extends TestClientAbstract {
    public static final String RESOURCE_URI = "/separate";
    public final CoAP.ResponseCode EXPECTED_RESPONSE_CODE = CoAP.ResponseCode.CONTENT;
    private static final long wait = 45000L;

    public CC16(String serverURI) {
        super(CC16.class.getSimpleName());
        Request request = new Request(CoAP.Code.GET, CoAP.Type.CON);
        this.executeRequest(request, serverURI, RESOURCE_URI);
    }

    @Override
    protected boolean checkResponse(Request request, Response response) {
        boolean success = true;
        success &= this.checkType(CoAP.Type.CON, response.getType());
        success &= this.checkCode(this.EXPECTED_RESPONSE_CODE, response.getCode());
        success &= this.hasContentType(response);
        return success &= this.hasNonEmptyPayload(response);
    }

    @Override
    protected synchronized void executeRequest(Request request, String serverURI, String resourceUri) {
        if (!serverURI.endsWith("/") && !resourceUri.startsWith("/")) {
            resourceUri = "/" + resourceUri;
        }
        URI uri = null;
        try {
            uri = new URI(serverURI + resourceUri);
        }
        catch (URISyntaxException use) {
            System.err.println("Invalid URI: " + use.getMessage());
        }
        request.setURI(uri);
        CC16.addContextObserver(request);
        if (this.verbose) {
            System.out.println("Request for test " + this.testName + " sent");
            Utils.prettyPrint(request);
        }
        try {
            Response response = null;
            boolean success = true;
            request.send();
            response = request.waitForResponse(45000L);
            if (response != null) {
                success &= this.checkResponse(request, response);
            }
            request.send();
            response = request.waitForResponse(5000L);
            if (response == null) {
                System.out.println("PASS: No duplicate");
            } else {
                System.out.println("PASS: Duplicate");
            }
            if (success) {
                System.out.println("**** TEST PASSED ****");
                this.addSummaryEntry(this.testName + ": PASSED");
            } else {
                System.out.println("**** TEST FAILED ****");
                this.addSummaryEntry(this.testName + ": --FAILED--");
            }
            this.tickOffTest();
        }
        catch (InterruptedException e) {
            System.err.println("Interupted during receive: " + e.getMessage());
            System.exit(-1);
        }
    }
}

