/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.x509;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.eclipse.californium.elements.util.SslContextUtil;
import org.eclipse.californium.scandium.dtls.CertificateIdentityResult;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.HandshakeResultHandler;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.cipher.XECDHECryptography;
import org.eclipse.californium.scandium.dtls.x509.CertificateConfigurationHelper;
import org.eclipse.californium.scandium.dtls.x509.CertificateProvider;
import org.eclipse.californium.scandium.dtls.x509.ConfigurationHelperSetup;
import org.eclipse.californium.scandium.util.ServerNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleCertificateProvider
implements CertificateProvider,
ConfigurationHelperSetup {
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleCertificateProvider.class);
    private final PrivateKey privateKey;
    private final PublicKey publicKey;
    private final List<X509Certificate> certificateChain;
    private final List<CertificateType> supportedCertificateTypes;
    private final List<CipherSuite.CertificateKeyAlgorithm> supportedCertificateKeyAlgorithms;
    private boolean verifyKeyPair = true;

    public SingleCertificateProvider(PrivateKey privateKey, Certificate[] certificateChain, CertificateType ... supportedCertificateTypes) {
        this(privateKey, certificateChain, SingleCertificateProvider.asList(supportedCertificateTypes));
    }

    public SingleCertificateProvider(PrivateKey privateKey, Certificate[] certificateChain, List<CertificateType> supportedCertificateTypes) {
        if (privateKey == null) {
            throw new NullPointerException("Private key must not be null!");
        }
        if (certificateChain == null) {
            throw new NullPointerException("Certificate chain must not be null!");
        }
        if (certificateChain.length == 0) {
            throw new IllegalArgumentException("Certificate chain must not be empty!");
        }
        if (supportedCertificateTypes != null) {
            if (supportedCertificateTypes.isEmpty()) {
                throw new IllegalArgumentException("Certificate types must not be empty!");
            }
            for (CertificateType certificateType : supportedCertificateTypes) {
                if (certificateType.isSupported()) continue;
                throw new IllegalArgumentException("Certificate type " + (Object)((Object)certificateType) + " is not supported!");
            }
        }
        this.privateKey = privateKey;
        this.publicKey = certificateChain[0].getPublicKey();
        if (supportedCertificateTypes == null) {
            supportedCertificateTypes = new ArrayList<CertificateType>(1);
            supportedCertificateTypes.add(CertificateType.X_509);
        }
        this.certificateChain = supportedCertificateTypes.contains((Object)CertificateType.X_509) ? Arrays.asList(SslContextUtil.asX509Certificates(certificateChain)) : null;
        this.supportedCertificateTypes = Collections.unmodifiableList(supportedCertificateTypes);
        this.supportedCertificateKeyAlgorithms = Collections.unmodifiableList(Arrays.asList(CipherSuite.CertificateKeyAlgorithm.getAlgorithm(this.publicKey)));
    }

    public SingleCertificateProvider(PrivateKey privateKey, PublicKey publicKey) {
        if (privateKey == null) {
            throw new NullPointerException("Private key must not be null!");
        }
        if (publicKey == null) {
            throw new NullPointerException("Public key must not be null!");
        }
        this.privateKey = privateKey;
        this.publicKey = publicKey;
        this.certificateChain = null;
        this.supportedCertificateTypes = Collections.unmodifiableList(Arrays.asList(CertificateType.RAW_PUBLIC_KEY));
        this.supportedCertificateKeyAlgorithms = Collections.unmodifiableList(Arrays.asList(CipherSuite.CertificateKeyAlgorithm.getAlgorithm(publicKey)));
    }

    public SingleCertificateProvider setVerifyKeyPair(boolean enable) {
        this.verifyKeyPair = enable;
        return this;
    }

    @Override
    public void setupConfigurationHelper(CertificateConfigurationHelper helper) {
        if (helper == null) {
            throw new NullPointerException("Certificate configuration helper must not be null!");
        }
        try {
            helper.verifyKeyPair(this.privateKey, this.publicKey);
        }
        catch (IllegalArgumentException ex) {
            if (this.verifyKeyPair) {
                throw new IllegalStateException(ex.getMessage());
            }
            LOGGER.warn("Mismatching key-pair, causing failure when used!", ex);
        }
        if (this.certificateChain != null) {
            helper.addConfigurationDefaultsFor(this.certificateChain);
        } else {
            helper.addConfigurationDefaultsFor(this.publicKey);
        }
    }

    @Override
    public List<CipherSuite.CertificateKeyAlgorithm> getSupportedCertificateKeyAlgorithms() {
        return this.supportedCertificateKeyAlgorithms;
    }

    @Override
    public List<CertificateType> getSupportedCertificateTypes() {
        return this.supportedCertificateTypes;
    }

    @Override
    public CertificateIdentityResult requestCertificateIdentity(ConnectionId cid, boolean client, List<X500Principal> issuers, ServerNames serverNames, List<CipherSuite.CertificateKeyAlgorithm> certificateKeyAlgorithms, List<SignatureAndHashAlgorithm> signatureAndHashAlgorithms, List<XECDHECryptography.SupportedGroup> curves) {
        if (this.certificateChain != null) {
            return new CertificateIdentityResult(cid, this.privateKey, this.certificateChain);
        }
        return new CertificateIdentityResult(cid, this.privateKey, this.publicKey);
    }

    @Override
    public void setResultHandler(HandshakeResultHandler resultHandler) {
    }

    private static List<CertificateType> asList(CertificateType[] types) {
        if (types == null || types.length == 0) {
            return null;
        }
        return Arrays.asList(types);
    }
}

