/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests.tests;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.core.Utils;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.plugtests.TestClientAbstract;

public class CC23
extends TestClientAbstract {
    public static final String RESOURCE_URI = "/create1";
    public static final CoAP.ResponseCode EXPECTED_RESPONSE_CODE_A = CoAP.ResponseCode.CREATED;
    public static final CoAP.ResponseCode EXPECTED_RESPONSE_CODE_B = CoAP.ResponseCode.PRECONDITION_FAILED;
    private char part = (char)65;

    public CC23(String serverURI) {
        super(CC23.class.getSimpleName());
        Request request = this.createRequest();
        this.executeRequest(request, serverURI, RESOURCE_URI);
    }

    private Request createRequest() {
        Request request = Request.newPut();
        request.setConfirmable(true);
        request.getOptions().setIfNoneMatch(true);
        request.getOptions().setContentFormat(0);
        request.setPayload("TD_COAP_CORE_23 Part " + this.part);
        CC23.addContextObserver(request);
        this.part = (char)(this.part + '\u0001');
        return request;
    }

    @Override
    protected synchronized void executeRequest(Request request, String serverURI, String resourceUri) {
        if (!serverURI.endsWith("/") && !resourceUri.startsWith("/")) {
            resourceUri = "/" + resourceUri;
        }
        URI uri = null;
        try {
            uri = new URI(serverURI + resourceUri);
            this.setUseTcp(uri.getScheme());
        }
        catch (URISyntaxException use) {
            throw new IllegalArgumentException("Invalid URI: " + use.getMessage());
        }
        CC23.addContextObserver(request);
        request.setURI(uri);
        if (this.verbose) {
            System.out.println("Request for test " + this.testName + " sent");
            Utils.prettyPrint(request);
        }
        try {
            Response response = null;
            boolean success = true;
            System.out.println();
            System.out.println("**** TEST: " + this.testName + " ****");
            System.out.println("**** BEGIN CHECK ****");
            request.send();
            response = request.waitForResponse(6000L);
            if (response != null && response.getCode() == CoAP.ResponseCode.PRECONDITION_FAILED) {
                System.out.println("**** TEST OUT-OF-SYNC, RETRY ****");
                request = this.createRequest();
                request.setURI(uri);
                request.send();
                response = request.waitForResponse(6000L);
            }
            if (response != null) {
                if (this.verbose) {
                    System.out.println("Response received");
                    System.out.println("Time elapsed (ms): " + TimeUnit.NANOSECONDS.toMillis(response.getApplicationRttNanos()));
                    Utils.prettyPrint(response);
                }
                success &= this.checkType(CoAP.Type.ACK, response.getType());
                success &= this.checkCode(EXPECTED_RESPONSE_CODE_A, response.getCode());
                request = this.createRequest();
                request.setURI(uri);
                request.send();
                response = request.waitForResponse(6000L);
                if (response != null) {
                    if (this.verbose) {
                        System.out.println("Response received");
                        System.out.println("Time elapsed (ms): " + TimeUnit.NANOSECONDS.toMillis(response.getApplicationRttNanos()));
                        Utils.prettyPrint(response);
                    }
                    success &= this.checkType(CoAP.Type.ACK, response.getType());
                    success &= this.checkCode(EXPECTED_RESPONSE_CODE_B, response.getCode());
                }
            }
            if (success) {
                System.out.println("**** TEST PASSED ****");
                this.addSummaryEntry(this.testName + ": PASSED");
            } else {
                System.out.println("**** TEST FAILED ****");
                this.addSummaryEntry(this.testName + ": --FAILED--");
            }
            this.tickOffTest();
        }
        catch (InterruptedException e) {
            System.err.println("Interupted during receive: " + e.getMessage());
            System.exit(-1);
        }
    }

    @Override
    protected boolean checkResponse(Request request, Response response) {
        return false;
    }
}

