/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests.tests;

import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.plugtests.TestClientAbstract;

public class CC14
extends TestClientAbstract {
    public static final String RESOURCE_URI = "/query";
    public final CoAP.ResponseCode EXPECTED_RESPONSE_CODE = CoAP.ResponseCode.CONTENT;

    public CC14(String serverURI) {
        super(CC14.class.getSimpleName());
        Request request = new Request(CoAP.Code.GET, CoAP.Type.CON);
        request.getOptions().addUriQuery("first=1");
        request.getOptions().addUriQuery("second=2");
        request.getOptions().addUriQuery("third=3");
        this.executeRequest(request, serverURI, RESOURCE_URI);
    }

    @Override
    protected boolean checkResponse(Request request, Response response) {
        boolean success = true;
        success &= this.checkTypes(new CoAP.Type[]{CoAP.Type.ACK, CoAP.Type.CON}, response.getType());
        success &= this.checkCode(this.EXPECTED_RESPONSE_CODE, response.getCode());
        success &= this.hasContentType(response);
        return success &= this.hasNonEmptyPayload(response);
    }
}

