/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.cipher;

import java.security.MessageDigest;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import org.eclipse.californium.elements.util.Asn1DerDecoder;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.scandium.dtls.cipher.AeadBlockCipher;
import org.eclipse.californium.scandium.dtls.cipher.ThreadLocalCipher;
import org.eclipse.californium.scandium.dtls.cipher.ThreadLocalMac;
import org.eclipse.californium.scandium.dtls.cipher.ThreadLocalMessageDigest;
import org.eclipse.californium.scandium.util.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum CipherSuite {
    TLS_ECDHE_PSK_WITH_AES_128_GCM_SHA256(53249, CertificateKeyAlgorithm.NONE, KeyExchangeAlgorithm.ECDHE_PSK, CipherSpec.AES_128_GCM, true),
    TLS_ECDHE_PSK_WITH_AES_256_GCM_SHA378(53250, CertificateKeyAlgorithm.NONE, KeyExchangeAlgorithm.ECDHE_PSK, CipherSpec.AES_256_GCM, true, PRFAlgorithm.TLS_PRF_SHA384),
    TLS_ECDHE_PSK_WITH_AES_128_CCM_8_SHA256(53251, CertificateKeyAlgorithm.NONE, KeyExchangeAlgorithm.ECDHE_PSK, CipherSpec.AES_128_CCM_8, true),
    TLS_ECDHE_PSK_WITH_AES_128_CCM_SHA256(53253, CertificateKeyAlgorithm.NONE, KeyExchangeAlgorithm.ECDHE_PSK, CipherSpec.AES_128_CCM, true),
    TLS_PSK_WITH_AES_128_GCM_SHA256(168, CertificateKeyAlgorithm.NONE, KeyExchangeAlgorithm.PSK, CipherSpec.AES_128_GCM, true),
    TLS_PSK_WITH_AES_256_GCM_SHA378(169, CertificateKeyAlgorithm.NONE, KeyExchangeAlgorithm.PSK, CipherSpec.AES_256_GCM, true, PRFAlgorithm.TLS_PRF_SHA384),
    TLS_PSK_WITH_AES_128_CCM_8(49320, CertificateKeyAlgorithm.NONE, KeyExchangeAlgorithm.PSK, CipherSpec.AES_128_CCM_8, true),
    TLS_PSK_WITH_AES_256_CCM_8(49321, CertificateKeyAlgorithm.NONE, KeyExchangeAlgorithm.PSK, CipherSpec.AES_256_CCM_8, true),
    TLS_PSK_WITH_AES_128_CCM(49316, CertificateKeyAlgorithm.NONE, KeyExchangeAlgorithm.PSK, CipherSpec.AES_128_CCM, true),
    TLS_PSK_WITH_AES_256_CCM(49317, CertificateKeyAlgorithm.NONE, KeyExchangeAlgorithm.PSK, CipherSpec.AES_256_CCM, true),
    TLS_PSK_WITH_ARIA_128_GCM_SHA256(49258, CertificateKeyAlgorithm.NONE, KeyExchangeAlgorithm.PSK, CipherSpec.ARIA_128_GCM, true),
    TLS_PSK_WITH_ARIA_256_GCM_SHA384(49259, CertificateKeyAlgorithm.NONE, KeyExchangeAlgorithm.PSK, CipherSpec.ARIA_256_GCM, true, PRFAlgorithm.TLS_PRF_SHA384),
    TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256(49207, CertificateKeyAlgorithm.NONE, KeyExchangeAlgorithm.ECDHE_PSK, CipherSpec.AES_128_CBC, MACAlgorithm.HMAC_SHA256, false),
    TLS_PSK_WITH_AES_128_CBC_SHA256(174, CertificateKeyAlgorithm.NONE, KeyExchangeAlgorithm.PSK, CipherSpec.AES_128_CBC, MACAlgorithm.HMAC_SHA256, false),
    TLS_ECDHE_PSK_WITH_ARIA_128_CBC_SHA256(49260, CertificateKeyAlgorithm.NONE, KeyExchangeAlgorithm.ECDHE_PSK, CipherSpec.ARIA_128_CBC, MACAlgorithm.HMAC_SHA256, false),
    TLS_PSK_WITH_ARIA_128_CBC_SHA256(49252, CertificateKeyAlgorithm.NONE, KeyExchangeAlgorithm.PSK, CipherSpec.ARIA_128_CBC, MACAlgorithm.HMAC_SHA256, false),
    TLS_PSK_WITH_ARIA_256_CBC_SHA384(49253, CertificateKeyAlgorithm.NONE, KeyExchangeAlgorithm.PSK, CipherSpec.ARIA_256_CBC, MACAlgorithm.HMAC_SHA384, false, PRFAlgorithm.TLS_PRF_SHA384),
    TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256(49195, CertificateKeyAlgorithm.EC, KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN, CipherSpec.AES_128_GCM, true),
    TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384(49196, CertificateKeyAlgorithm.EC, KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN, CipherSpec.AES_256_GCM, true, PRFAlgorithm.TLS_PRF_SHA384),
    TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8(49326, CertificateKeyAlgorithm.EC, KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN, CipherSpec.AES_128_CCM_8, true),
    TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8(49327, CertificateKeyAlgorithm.EC, KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN, CipherSpec.AES_256_CCM_8, true),
    TLS_ECDHE_ECDSA_WITH_AES_128_CCM(49324, CertificateKeyAlgorithm.EC, KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN, CipherSpec.AES_128_CCM, true),
    TLS_ECDHE_ECDSA_WITH_AES_256_CCM(49325, CertificateKeyAlgorithm.EC, KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN, CipherSpec.AES_256_CCM, true),
    TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256(49244, CertificateKeyAlgorithm.EC, KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN, CipherSpec.ARIA_128_GCM, true),
    TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384(49245, CertificateKeyAlgorithm.EC, KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN, CipherSpec.ARIA_256_GCM, true, PRFAlgorithm.TLS_PRF_SHA384),
    TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256(49187, CertificateKeyAlgorithm.EC, KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN, CipherSpec.AES_128_CBC, MACAlgorithm.HMAC_SHA256, false),
    TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384(49188, CertificateKeyAlgorithm.EC, KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN, CipherSpec.AES_256_CBC, MACAlgorithm.HMAC_SHA384, false, PRFAlgorithm.TLS_PRF_SHA384),
    TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA(49162, CertificateKeyAlgorithm.EC, KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN, CipherSpec.AES_256_CBC, MACAlgorithm.HMAC_SHA1, false),
    TLS_ECDHE_ECDSA_WITH_ARIA_128_CBC_SHA256(49224, CertificateKeyAlgorithm.EC, KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN, CipherSpec.ARIA_128_CBC, MACAlgorithm.HMAC_SHA256, false),
    TLS_ECDHE_ECDSA_WITH_ARIA_256_CBC_SHA384(49225, CertificateKeyAlgorithm.EC, KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN, CipherSpec.ARIA_256_CBC, MACAlgorithm.HMAC_SHA384, false, PRFAlgorithm.TLS_PRF_SHA384),
    TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256(49199, CertificateKeyAlgorithm.RSA, KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN, CipherSpec.AES_128_GCM, true),
    TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384(49200, CertificateKeyAlgorithm.RSA, KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN, CipherSpec.AES_256_GCM, true, PRFAlgorithm.TLS_PRF_SHA384),
    TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256(49191, CertificateKeyAlgorithm.RSA, KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN, CipherSpec.AES_128_CBC, MACAlgorithm.HMAC_SHA256, false),
    TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384(49192, CertificateKeyAlgorithm.RSA, KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN, CipherSpec.AES_256_CBC, MACAlgorithm.HMAC_SHA384, false, PRFAlgorithm.TLS_PRF_SHA384),
    TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA(49172, CertificateKeyAlgorithm.RSA, KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN, CipherSpec.AES_256_CBC, MACAlgorithm.HMAC_SHA1, false),
    TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256(49248, CertificateKeyAlgorithm.RSA, KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN, CipherSpec.ARIA_128_GCM, true),
    TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384(49249, CertificateKeyAlgorithm.RSA, KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN, CipherSpec.ARIA_256_GCM, true, PRFAlgorithm.TLS_PRF_SHA384),
    TLS_NULL_WITH_NULL_NULL(0),
    TLS_EMPTY_RENEGOTIATION_INFO_SCSV(255);

    private static final Logger LOGGER;
    public static final int CIPHER_SUITE_BITS = 16;
    public static final List<CipherSuite> STRONG_ENCRYPTION_PREFERENCE;
    private static int overallMaxCipherTextExpansion;
    private final int code;
    private final boolean validForNegotiation;
    private final CertificateKeyAlgorithm certificateKeyAlgorithm;
    private final KeyExchangeAlgorithm keyExchange;
    private final CipherSpec cipher;
    private final MACAlgorithm macAlgorithm;
    private final PRFAlgorithm pseudoRandomFunction;
    private final int maxCipherTextExpansion;
    private final boolean recommendedCipherSuite;

    private CipherSuite(int code) {
        this.code = code;
        this.validForNegotiation = false;
        this.certificateKeyAlgorithm = CertificateKeyAlgorithm.NONE;
        this.keyExchange = KeyExchangeAlgorithm.NULL;
        this.cipher = CipherSpec.NULL;
        this.macAlgorithm = MACAlgorithm.NULL;
        this.recommendedCipherSuite = false;
        this.pseudoRandomFunction = PRFAlgorithm.TLS_PRF_SHA256;
        this.maxCipherTextExpansion = 0;
    }

    private CipherSuite(int code, CertificateKeyAlgorithm certificate, KeyExchangeAlgorithm keyExchange, CipherSpec cipher, boolean recommendedCipherSuite) {
        this(code, certificate, keyExchange, cipher, MACAlgorithm.INTRINSIC, recommendedCipherSuite, PRFAlgorithm.TLS_PRF_SHA256);
    }

    private CipherSuite(int code, CertificateKeyAlgorithm certificate, KeyExchangeAlgorithm keyExchange, CipherSpec cipher, MACAlgorithm macAlgorithm, boolean recommendedCipherSuite) {
        this(code, certificate, keyExchange, cipher, macAlgorithm, recommendedCipherSuite, PRFAlgorithm.TLS_PRF_SHA256);
    }

    private CipherSuite(int code, CertificateKeyAlgorithm certificate, KeyExchangeAlgorithm keyExchange, CipherSpec cipher, boolean recommendedCipherSuite, PRFAlgorithm prf) {
        this(code, certificate, keyExchange, cipher, MACAlgorithm.INTRINSIC, recommendedCipherSuite, prf);
    }

    private CipherSuite(int code, CertificateKeyAlgorithm certificate, KeyExchangeAlgorithm keyExchange, CipherSpec cipher, MACAlgorithm macAlgorithm, boolean recommendedCipherSuite, PRFAlgorithm prf) {
        this.code = code;
        this.validForNegotiation = true;
        this.certificateKeyAlgorithm = certificate;
        this.keyExchange = keyExchange;
        this.cipher = cipher;
        this.macAlgorithm = macAlgorithm;
        this.recommendedCipherSuite = recommendedCipherSuite;
        this.pseudoRandomFunction = prf;
        switch (this.cipher.getType()) {
            case BLOCK: {
                this.maxCipherTextExpansion = cipher.getRecordIvLength() + macAlgorithm.getOutputLength() + cipher.getRecordIvLength() + 1;
                break;
            }
            case AEAD: {
                this.maxCipherTextExpansion = cipher.getRecordIvLength() + cipher.getMacLength();
                break;
            }
            default: {
                this.maxCipherTextExpansion = 0;
            }
        }
    }

    public int getMaxCiphertextExpansion() {
        return this.maxCipherTextExpansion;
    }

    public String getTransformation() {
        return this.cipher.getTransformation();
    }

    public Cipher getThreadLocalCipher() {
        return this.cipher.getCipher();
    }

    public int getCode() {
        return this.code;
    }

    public CertificateKeyAlgorithm getCertificateKeyAlgorithm() {
        return this.certificateKeyAlgorithm;
    }

    public KeyExchangeAlgorithm getKeyExchange() {
        return this.keyExchange;
    }

    public boolean requiresServerCertificateMessage() {
        return !CertificateKeyAlgorithm.NONE.equals((Object)this.certificateKeyAlgorithm);
    }

    public boolean isPskBased() {
        return KeyExchangeAlgorithm.PSK.equals((Object)this.keyExchange) || KeyExchangeAlgorithm.ECDHE_PSK.equals((Object)this.keyExchange);
    }

    public boolean isEccBased() {
        return CertificateKeyAlgorithm.EC.equals((Object)this.certificateKeyAlgorithm) || KeyExchangeAlgorithm.ECDHE_PSK.equals((Object)this.keyExchange) || KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN.equals((Object)this.keyExchange);
    }

    public boolean isSupported() {
        return this.pseudoRandomFunction.getMacAlgorithm().isSupported() && this.macAlgorithm.isSupported() && this.cipher.isSupported();
    }

    public boolean isRecommended() {
        return this.recommendedCipherSuite;
    }

    public boolean isValidForNegotiation() {
        return this.validForNegotiation;
    }

    public String getMacName() {
        return this.macAlgorithm.getName();
    }

    public String getMessageDigestName() {
        return this.macAlgorithm.getMessageDigestName();
    }

    public Mac getThreadLocalMac() {
        return this.macAlgorithm.getMac();
    }

    public MessageDigest getThreadLocalMacMessageDigest() {
        return this.macAlgorithm.getMessageDigest();
    }

    public int getMacLength() {
        if (this.macAlgorithm == MACAlgorithm.INTRINSIC) {
            return this.cipher.getMacLength();
        }
        return this.macAlgorithm.getOutputLength();
    }

    public int getMacKeyLength() {
        return this.macAlgorithm.getKeyLength();
    }

    public int getMacMessageBlockLength() {
        return this.macAlgorithm.getMessageBlockLength();
    }

    public int getMacMessageLengthBytes() {
        return this.macAlgorithm.getMessageLengthBytes();
    }

    public int getRecordIvLength() {
        return this.cipher.getRecordIvLength();
    }

    public int getFixedIvLength() {
        return this.cipher.getFixedIvLength();
    }

    public String getPseudoRandomFunctionMacName() {
        return this.pseudoRandomFunction.getMacAlgorithm().getName();
    }

    public String getPseudoRandomFunctionMessageDigestName() {
        return this.pseudoRandomFunction.getMacAlgorithm().getMessageDigestName();
    }

    public Mac getThreadLocalPseudoRandomFunctionMac() {
        return this.pseudoRandomFunction.getMacAlgorithm().getMac();
    }

    public MessageDigest getThreadLocalPseudoRandomFunctionMessageDigest() {
        return this.pseudoRandomFunction.getMacAlgorithm().getMessageDigest();
    }

    public CipherType getCipherType() {
        return this.cipher.getType();
    }

    public int getEncKeyLength() {
        return this.cipher.getKeyLength();
    }

    public static int getOverallMaxCiphertextExpansion() {
        if (overallMaxCipherTextExpansion == 0) {
            int overall = 0;
            for (CipherSuite suite : CipherSuite.values()) {
                if (!suite.isSupported()) continue;
                overall = Math.max(overall, suite.getMaxCiphertextExpansion());
            }
            overallMaxCipherTextExpansion = overall;
        }
        return overallMaxCipherTextExpansion;
    }

    public static CipherSuite[] getCipherSuites(boolean recommendedCipherSuitesOnly, boolean supportedCipherSuitesOnly) {
        ArrayList<CipherSuite> list = new ArrayList<CipherSuite>();
        for (CipherSuite suite : CipherSuite.values()) {
            if (!suite.isValidForNegotiation() || supportedCipherSuitesOnly && !suite.isSupported() || recommendedCipherSuitesOnly && !suite.isRecommended()) continue;
            list.add(suite);
        }
        return list.toArray(new CipherSuite[list.size()]);
    }

    public static List<CipherSuite> getCipherSuitesByKeyExchangeAlgorithm(boolean recommendedCipherSuitesOnly, KeyExchangeAlgorithm ... keyExchangeAlgorithms) {
        if (keyExchangeAlgorithms == null) {
            throw new NullPointerException("KeyExchangeAlgorithms must not be null!");
        }
        if (keyExchangeAlgorithms.length == 0) {
            throw new IllegalArgumentException("KeyExchangeAlgorithms must not be empty!");
        }
        return CipherSuite.getCipherSuitesByKeyExchangeAlgorithm(recommendedCipherSuitesOnly, false, Arrays.asList(keyExchangeAlgorithms));
    }

    public static List<CipherSuite> getCipherSuitesByKeyExchangeAlgorithm(boolean recommendedCipherSuitesOnly, boolean orderedByKeyExchangeAlgorithm, List<KeyExchangeAlgorithm> keyExchangeAlgorithms) {
        if (keyExchangeAlgorithms == null) {
            throw new NullPointerException("KeyExchangeAlgorithms must not be null!");
        }
        if (keyExchangeAlgorithms.isEmpty()) {
            throw new IllegalArgumentException("KeyExchangeAlgorithms must not be empty!");
        }
        ArrayList<CipherSuite> list = new ArrayList<CipherSuite>();
        if (orderedByKeyExchangeAlgorithm) {
            for (KeyExchangeAlgorithm keyExchange : keyExchangeAlgorithms) {
                for (CipherSuite suite : CipherSuite.values()) {
                    if (recommendedCipherSuitesOnly && !suite.recommendedCipherSuite || !suite.isSupported() || !keyExchange.equals((Object)suite.keyExchange)) continue;
                    ListUtils.addIfAbsent(list, suite);
                }
            }
        } else {
            for (CipherSuite suite : CipherSuite.values()) {
                if (recommendedCipherSuitesOnly && !suite.recommendedCipherSuite || !suite.isSupported() || !keyExchangeAlgorithms.contains((Object)suite.keyExchange)) continue;
                ListUtils.addIfAbsent(list, suite);
            }
        }
        return list;
    }

    public static List<CipherSuite> getCertificateCipherSuites(boolean recommendedCipherSuitesOnly, PublicKey key) {
        if (key == null) {
            throw new NullPointerException("Public key must not be null!");
        }
        return CipherSuite.getCertificateCipherSuites(recommendedCipherSuitesOnly, Arrays.asList(CertificateKeyAlgorithm.getAlgorithm(key)));
    }

    public static List<CipherSuite> getCertificateCipherSuites(boolean recommendedCipherSuitesOnly, CertificateKeyAlgorithm ... certificateKeyAlgorithms) {
        if (certificateKeyAlgorithms == null) {
            throw new NullPointerException("Certificate key algorithms must not be null!");
        }
        if (certificateKeyAlgorithms.length == 0) {
            throw new IllegalArgumentException("Certificate key algorithms must not be empty!");
        }
        return CipherSuite.getCertificateCipherSuites(recommendedCipherSuitesOnly, Arrays.asList(certificateKeyAlgorithms));
    }

    public static List<CipherSuite> getCertificateCipherSuites(boolean recommendedCipherSuitesOnly, List<CertificateKeyAlgorithm> certificateKeyAlgorithms) {
        if (certificateKeyAlgorithms == null) {
            throw new NullPointerException("Certificate key algorithms must not be null!");
        }
        if (certificateKeyAlgorithms.isEmpty()) {
            throw new IllegalArgumentException("Certificate key algorithms must not be empty!");
        }
        ArrayList<CipherSuite> list = new ArrayList<CipherSuite>();
        for (CipherSuite suite : CipherSuite.values()) {
            if (!suite.isSupported() || recommendedCipherSuitesOnly && !suite.recommendedCipherSuite || !certificateKeyAlgorithms.contains((Object)suite.certificateKeyAlgorithm)) continue;
            list.add(suite);
        }
        return list;
    }

    public static List<CertificateKeyAlgorithm> getCertificateKeyAlgorithms(List<CipherSuite> cipherSuites) {
        ArrayList<CertificateKeyAlgorithm> types = new ArrayList<CertificateKeyAlgorithm>();
        for (CipherSuite suite : cipherSuites) {
            if (suite.getCertificateKeyAlgorithm() == CertificateKeyAlgorithm.NONE) continue;
            ListUtils.addIfAbsent(types, suite.getCertificateKeyAlgorithm());
        }
        return types;
    }

    public static CipherSuite getTypeByCode(int code) {
        for (CipherSuite suite : CipherSuite.values()) {
            if (suite.code != code) continue;
            return suite;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Cannot resolve cipher suite code [{}]", (Object)Integer.toHexString(code));
        }
        return null;
    }

    public static CipherSuite getTypeByName(String name) {
        for (CipherSuite suite : CipherSuite.values()) {
            if (!suite.name().equals(name)) continue;
            return suite;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Cannot resolve cipher suite code [{}]", (Object)name);
        }
        return null;
    }

    public static List<CipherSuite> getTypesByNames(String ... names) {
        ArrayList<CipherSuite> suites = new ArrayList<CipherSuite>(names.length);
        for (int i = 0; i < names.length; ++i) {
            CipherSuite knownSuite = CipherSuite.getTypeByName(names[i]);
            if (knownSuite == null) {
                throw new IllegalArgumentException(String.format("Cipher suite [%s] is not (yet) supported", names[i]));
            }
            suites.add(knownSuite);
        }
        return suites;
    }

    public static boolean containsPskBasedCipherSuite(List<CipherSuite> cipherSuites) {
        if (cipherSuites != null) {
            for (CipherSuite cipherSuite : cipherSuites) {
                if (!cipherSuite.isPskBased()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsEccBasedCipherSuite(List<CipherSuite> cipherSuites) {
        if (cipherSuites != null) {
            for (CipherSuite cipherSuite : cipherSuites) {
                if (!cipherSuite.isEccBased()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsCipherSuiteRequiringCertExchange(List<CipherSuite> cipherSuites) {
        if (cipherSuites != null) {
            for (CipherSuite cipherSuite : cipherSuites) {
                if (!cipherSuite.requiresServerCertificateMessage()) continue;
                return true;
            }
        }
        return false;
    }

    public static List<CipherSuite> preselectCipherSuites(List<CipherSuite> cipherSuites, List<CipherSuite> preselect) {
        if (cipherSuites == null) {
            throw new NullPointerException("The cipher-suites must not be null!");
        }
        if (preselect == null) {
            throw new NullPointerException("The preselected cipher-suites must not be null!");
        }
        if (cipherSuites.isEmpty()) {
            throw new IllegalArgumentException("The cipher-suites must not be empty");
        }
        if (preselect.isEmpty()) {
            throw new IllegalArgumentException("The preselected cipher-suites must not be empty!");
        }
        ArrayList<CipherSuite> ordered = new ArrayList<CipherSuite>();
        for (CipherSuite cipherSuite : preselect) {
            if (!cipherSuite.isValidForNegotiation() || !cipherSuites.contains((Object)cipherSuite)) continue;
            ordered.add(cipherSuite);
        }
        return ordered;
    }

    public static void listToWriter(DatagramWriter writer, List<CipherSuite> cipherSuites) {
        for (CipherSuite cipherSuite : cipherSuites) {
            writer.write(cipherSuite.getCode(), 16);
        }
    }

    public static List<CipherSuite> listFromReader(DatagramReader reader) {
        ArrayList<CipherSuite> cipherSuites = new ArrayList<CipherSuite>();
        while (reader.bytesAvailable()) {
            int code = reader.read(16);
            CipherSuite cipher = CipherSuite.getTypeByCode(code);
            if (cipher == null) continue;
            cipherSuites.add(cipher);
        }
        return cipherSuites;
    }

    static {
        LOGGER = LoggerFactory.getLogger(CipherSuite.class);
        ArrayList<CipherSuite> secureSuites = new ArrayList<CipherSuite>();
        secureSuites.addAll(CipherSuite.getCipherSuitesByKeyExchangeAlgorithm(false, KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN));
        secureSuites.addAll(CipherSuite.getCipherSuitesByKeyExchangeAlgorithm(false, KeyExchangeAlgorithm.ECDHE_PSK));
        secureSuites.addAll(CipherSuite.getCipherSuitesByKeyExchangeAlgorithm(false, KeyExchangeAlgorithm.PSK));
        ArrayList<CipherSuite> ccm8 = new ArrayList<CipherSuite>();
        Iterator iterator = secureSuites.iterator();
        while (iterator.hasNext()) {
            CipherSuite cipherSuite = (CipherSuite)((Object)iterator.next());
            if (cipherSuite.getMacLength() >= 16) continue;
            ccm8.add(cipherSuite);
            iterator.remove();
        }
        secureSuites.addAll(ccm8);
        STRONG_ENCRYPTION_PREFERENCE = Collections.unmodifiableList(secureSuites);
        overallMaxCipherTextExpansion = 0;
    }

    public static enum CertificateKeyAlgorithm {
        NONE,
        DSA,
        RSA,
        EC;


        public boolean isCompatible(PublicKey key) {
            if (this == NONE) {
                return key == null;
            }
            if (key == null) {
                return false;
            }
            return this.isCompatible(key.getAlgorithm());
        }

        public boolean isCompatible(String keyAlgorithm) {
            if (keyAlgorithm.equalsIgnoreCase(this.name())) {
                return true;
            }
            if (this == EC) {
                return Asn1DerDecoder.isEcBased(keyAlgorithm);
            }
            return false;
        }

        public boolean isCompatible(List<String> keyAlgorithms) {
            for (String algorithm : keyAlgorithms) {
                if (!this.isCompatible(algorithm)) continue;
                return true;
            }
            return false;
        }

        public static CertificateKeyAlgorithm getAlgorithm(PublicKey key) {
            for (CertificateKeyAlgorithm keyAlgorithm : CertificateKeyAlgorithm.values()) {
                if (!keyAlgorithm.isCompatible(key)) continue;
                return keyAlgorithm;
            }
            return null;
        }
    }

    public static enum KeyExchangeAlgorithm {
        NULL,
        DHE_DSS,
        DHE_RSA,
        DH_ANON,
        RSA,
        DH_DSS,
        DH_RSA,
        PSK,
        ECDHE_PSK,
        EC_DIFFIE_HELLMAN;

    }

    private static enum CipherSpec {
        NULL("NULL", CipherType.NULL, 0, 0, 0),
        AES_128_CBC("AES/CBC/NoPadding", CipherType.BLOCK, 16, 0, 16),
        AES_256_CBC("AES/CBC/NoPadding", CipherType.BLOCK, 32, 0, 16),
        AES_128_CCM_8("AES/CCM/NoPadding", CipherType.AEAD, 16, 4, 8, 8),
        AES_256_CCM_8("AES/CCM/NoPadding", CipherType.AEAD, 32, 4, 8, 8),
        AES_128_CCM("AES/CCM/NoPadding", CipherType.AEAD, 16, 4, 8, 16),
        AES_256_CCM("AES/CCM/NoPadding", CipherType.AEAD, 32, 4, 8, 16),
        AES_128_GCM("AES/GCM/NoPadding", CipherType.AEAD, 16, 4, 8, 16),
        AES_256_GCM("AES/GCM/NoPadding", CipherType.AEAD, 32, 4, 8, 16),
        ARIA_128_CBC("ARIA/CBC/NoPadding", CipherType.BLOCK, 16, 0, 16),
        ARIA_256_CBC("ARIA/CBC/NoPadding", CipherType.BLOCK, 32, 0, 16),
        ARIA_128_GCM("ARIA/GCM/NoPadding", CipherType.AEAD, 16, 4, 8, 16),
        ARIA_256_GCM("ARIA/GCM/NoPadding", CipherType.AEAD, 32, 4, 8, 16);

        private final String transformation;
        private final CipherType type;
        private final int keyLength;
        private final int fixedIvLength;
        private final int recordIvLength;
        private final int macLength;
        private final boolean supported;
        private final ThreadLocalCipher cipher;

        private CipherSpec(String transformation, CipherType type, int keyLength, int fixedIvLength, int recordIvLength) {
            this(transformation, type, keyLength, fixedIvLength, recordIvLength, 0);
        }

        private CipherSpec(String transformation, CipherType type, int keyLength, int fixedIvLength, int recordIvLength, int macLength) {
            this.transformation = transformation;
            this.type = type;
            this.keyLength = keyLength;
            this.fixedIvLength = fixedIvLength;
            this.recordIvLength = recordIvLength;
            this.macLength = macLength;
            boolean supported = true;
            if (type == CipherType.AEAD || type == CipherType.BLOCK) {
                supported = AeadBlockCipher.isSupported(transformation, keyLength);
            }
            if ("AES/CCM/NoPadding".equals(transformation)) {
                this.cipher = null;
                this.supported = supported;
            } else {
                this.cipher = supported ? new ThreadLocalCipher(transformation) : null;
                this.supported = this.cipher == null ? false : this.cipher.isSupported();
            }
        }

        private String getTransformation() {
            return this.transformation;
        }

        private CipherType getType() {
            return this.type;
        }

        private int getKeyLength() {
            return this.keyLength;
        }

        private int getFixedIvLength() {
            return this.fixedIvLength;
        }

        private int getRecordIvLength() {
            return this.recordIvLength;
        }

        private int getMacLength() {
            return this.macLength;
        }

        private boolean isSupported() {
            return this.supported;
        }

        private Cipher getCipher() {
            return this.cipher == null ? null : (Cipher)this.cipher.current();
        }
    }

    private static enum MACAlgorithm {
        NULL(null, null, 0, 0, 0),
        INTRINSIC(null, null, 0, 0, 0),
        HMAC_SHA1("HmacSHA1", "SHA-1", 20, 8, 64),
        HMAC_SHA256("HmacSHA256", "SHA-256", 32, 8, 64),
        HMAC_SHA384("HmacSHA384", "SHA-384", 48, 16, 128),
        HMAC_SHA512("HmacSHA512", "SHA-512", 64, 16, 128);

        private final String name;
        private final String mdName;
        private final int outputLength;
        private final int messageLengthBytes;
        private final int messageBlockLength;
        private final boolean supported;
        private final ThreadLocalMac mac;
        private final ThreadLocalMessageDigest md;

        private MACAlgorithm(String name, String mdName, int outputLength, int messageLengthBytes, int messageBlockLength) {
            this.name = name;
            this.mdName = mdName;
            this.outputLength = outputLength;
            this.messageLengthBytes = messageLengthBytes;
            this.messageBlockLength = messageBlockLength;
            if (name == null && mdName == null) {
                this.supported = true;
                this.mac = null;
                this.md = null;
            } else {
                this.mac = new ThreadLocalMac(name);
                this.md = new ThreadLocalMessageDigest(mdName);
                this.supported = this.mac.isSupported() && this.md.isSupported();
            }
        }

        public String getName() {
            return this.name;
        }

        public String getMessageDigestName() {
            return this.mdName;
        }

        public int getOutputLength() {
            return this.outputLength;
        }

        public int getKeyLength() {
            return this.outputLength;
        }

        public int getMessageBlockLength() {
            return this.messageBlockLength;
        }

        public int getMessageLengthBytes() {
            return this.messageLengthBytes;
        }

        public boolean isSupported() {
            return this.supported;
        }

        public Mac getMac() {
            if (this.mac != null) {
                Mac current = (Mac)this.mac.current();
                return current;
            }
            return null;
        }

        public MessageDigest getMessageDigest() {
            if (this.md != null) {
                MessageDigest current = (MessageDigest)this.md.current();
                current.reset();
                return current;
            }
            return null;
        }
    }

    private static enum PRFAlgorithm {
        TLS_PRF_SHA256(MACAlgorithm.HMAC_SHA256),
        TLS_PRF_SHA384(MACAlgorithm.HMAC_SHA384);

        private final MACAlgorithm mac;

        private PRFAlgorithm(MACAlgorithm mac) {
            this.mac = mac;
        }

        public MACAlgorithm getMacAlgorithm() {
            return this.mac;
        }
    }

    public static enum CipherType {
        NULL,
        STREAM,
        BLOCK,
        AEAD;

    }
}

