/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.List;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.HandshakeResult;

public final class CertificateIdentityResult
extends HandshakeResult {
    private final PrivateKey privateKey;
    private final PublicKey publicKey;
    private final List<X509Certificate> certificateChain;

    @Deprecated
    public CertificateIdentityResult(ConnectionId cid, PrivateKey privateKey, List<X509Certificate> certificateChain, Object customArgument) {
        super(cid, customArgument);
        if (privateKey == null) {
            throw new NullPointerException("Private key must not be null!");
        }
        if (certificateChain == null) {
            throw new NullPointerException("Certificate chain must not be null!");
        }
        if (certificateChain.isEmpty()) {
            throw new IllegalArgumentException("Certificate chain must not be empty!");
        }
        this.privateKey = privateKey;
        this.publicKey = certificateChain.get(0).getPublicKey();
        this.certificateChain = certificateChain;
    }

    @Deprecated
    public CertificateIdentityResult(ConnectionId cid, PrivateKey privateKey, PublicKey publicKey, Object customArgument) {
        super(cid, customArgument);
        if (privateKey == null) {
            throw new NullPointerException("Private key must not be null!");
        }
        if (publicKey == null) {
            throw new NullPointerException("Public key must not be null!");
        }
        this.privateKey = privateKey;
        this.publicKey = publicKey;
        this.certificateChain = null;
    }

    @Deprecated
    public CertificateIdentityResult(ConnectionId cid, Object customArgument) {
        super(cid, customArgument);
        this.privateKey = null;
        this.publicKey = null;
        this.certificateChain = null;
    }

    public CertificateIdentityResult(ConnectionId cid, PrivateKey privateKey, List<X509Certificate> certificateChain) {
        super(cid, null);
        if (privateKey == null) {
            throw new NullPointerException("Private key must not be null!");
        }
        if (certificateChain == null) {
            throw new NullPointerException("Certificate chain must not be null!");
        }
        if (certificateChain.isEmpty()) {
            throw new IllegalArgumentException("Certificate chain must not be empty!");
        }
        this.privateKey = privateKey;
        this.publicKey = certificateChain.get(0).getPublicKey();
        this.certificateChain = certificateChain;
    }

    public CertificateIdentityResult(ConnectionId cid, PrivateKey privateKey, PublicKey publicKey) {
        super(cid, null);
        if (privateKey == null) {
            throw new NullPointerException("Private key must not be null!");
        }
        if (publicKey == null) {
            throw new NullPointerException("Public key must not be null!");
        }
        this.privateKey = privateKey;
        this.publicKey = publicKey;
        this.certificateChain = null;
    }

    public CertificateIdentityResult(ConnectionId cid) {
        super(cid, null);
        this.privateKey = null;
        this.publicKey = null;
        this.certificateChain = null;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public List<X509Certificate> getCertificateChain() {
        return this.certificateChain;
    }
}

