/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class Catalog {
    private static final String PACKAGE = "org.eclipse.californium.plugtests.tests";
    private HashMap<String, Class<?>> catalog = new HashMap();

    public Catalog() {
        try {
            this.loadSubclasses();
        }
        catch (Exception e) {
            System.err.println("Reflection error.");
            e.printStackTrace();
            return;
        }
    }

    public void loadSubclasses() throws Exception {
        String packageName;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL packageURL = classLoader.getResource(packageName = PACKAGE.replace(".", "/"));
        if (packageURL.getProtocol().equals("jar")) {
            String jarFileName = URLDecoder.decode(packageURL.getFile(), "UTF-8");
            jarFileName = jarFileName.substring(5, jarFileName.indexOf("!"));
            JarFile jar = new JarFile(jarFileName);
            Enumeration<JarEntry> jarEntries = jar.entries();
            while (jarEntries.hasMoreElements()) {
                String clazz = jarEntries.nextElement().getName();
                if (!clazz.startsWith(packageName) || clazz.length() <= packageName.length() + 5) continue;
                clazz = clazz.substring(0, clazz.length() - 6);
                clazz = clazz.replace("/", ".");
                this.loadClass(Class.forName(clazz));
            }
            jar.close();
        } else {
            File[] content;
            URI uri = new URI(packageURL.toString());
            File folder = new File(uri.getPath());
            for (File file : content = folder.listFiles()) {
                String clazz = file.getName().substring(0, file.getName().length() - 6);
                this.loadClass(Class.forName("org.eclipse.californium.plugtests.tests." + clazz));
            }
        }
    }

    public void loadClass(Class<?> clazz) {
        if (!clazz.getSimpleName().isEmpty()) {
            this.catalog.put(clazz.getSimpleName(), clazz);
        }
    }

    public Class<?> getTestClass(String name) {
        return this.catalog.get(name);
    }

    public List<Class<?>> getTestsClasses(List<String> names) {
        if (names == null || names.isEmpty()) {
            names = Arrays.asList(".*");
        } else {
            ArrayList<String> regexs = new ArrayList<String>(names.size());
            for (int index = 0; index < names.size(); ++index) {
                String regex = names.get(index).replace("*", ".*");
                regexs.add(regex);
            }
            names = regexs;
        }
        ArrayList list = new ArrayList();
        for (Map.Entry<String, Class<?>> entry : this.catalog.entrySet()) {
            for (String regex : names) {
                if (!entry.getKey().matches(regex)) continue;
                list.add(entry.getValue());
            }
        }
        Collections.sort(list, new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> o1, Class<?> o2) {
                return o1.getSimpleName().compareTo(o2.getSimpleName());
            }
        });
        return list;
    }

    public List<String> getAllTestNames() {
        ArrayList<String> list = new ArrayList<String>(this.catalog.keySet());
        Collections.sort(list);
        return list;
    }
}

