/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.pskstore;

import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.HandshakeResultHandler;
import org.eclipse.californium.scandium.dtls.PskPublicInformation;
import org.eclipse.californium.scandium.dtls.PskSecretResult;
import org.eclipse.californium.scandium.dtls.pskstore.AdvancedPskStore;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.eclipse.californium.scandium.util.ServerName;
import org.eclipse.californium.scandium.util.ServerNames;

public class AdvancedMultiPskStore
implements AdvancedPskStore,
Destroyable {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private static final ServerName GLOBAL_SCOPE = ServerName.from(ServerName.NameType.UNDEFINED, Bytes.EMPTY);
    private final Map<ServerName, Map<PskPublicInformation, PskCredentials>> scopedKeys = new ConcurrentHashMap<ServerName, Map<PskPublicInformation, PskCredentials>>();
    private final Map<InetSocketAddress, Map<ServerName, PskPublicInformation>> scopedIdentities = new ConcurrentHashMap<InetSocketAddress, Map<ServerName, PskPublicInformation>>();
    private volatile boolean destroyed;

    @Override
    public boolean hasEcdhePskSupported() {
        return true;
    }

    @Override
    public PskSecretResult requestPskSecretResult(ConnectionId cid, ServerNames serverNames, PskPublicInformation identity, String hmacAlgorithm, SecretKey otherSecret, byte[] seed, boolean useExtendedMasterSecret) {
        PskCredentials credentials = this.getCredentials(serverNames, identity);
        if (credentials != null) {
            return new PskSecretResult(cid, credentials.getIdentity(), credentials.getKey());
        }
        return new PskSecretResult(cid, identity, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PskCredentials getCredentials(ServerNames serverNames, PskPublicInformation identity) {
        PskCredentials credentials;
        block6: {
            credentials = null;
            if (identity == null) {
                throw new NullPointerException("identity must not be null");
            }
            this.lock.readLock().lock();
            try {
                if (serverNames == null) {
                    credentials = AdvancedMultiPskStore.getPskCredentials(identity, this.scopedKeys.get(GLOBAL_SCOPE));
                    break block6;
                }
                for (ServerName serverName : serverNames) {
                    credentials = AdvancedMultiPskStore.getPskCredentials(identity, this.scopedKeys.get(serverName));
                    if (credentials == null) continue;
                    break;
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        return credentials;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PskPublicInformation getIdentity(InetSocketAddress peerAddress, ServerNames virtualHost) {
        if (peerAddress == null) {
            throw new NullPointerException("address must not be null");
        }
        this.lock.readLock().lock();
        try {
            if (virtualHost == null) {
                PskPublicInformation pskPublicInformation = AdvancedMultiPskStore.getIdentityFromMap(GLOBAL_SCOPE, this.scopedIdentities.get(peerAddress));
                return pskPublicInformation;
            }
            for (ServerName serverName : virtualHost) {
                PskPublicInformation identity = AdvancedMultiPskStore.getIdentityFromMap(serverName, this.scopedIdentities.get(peerAddress));
                if (identity == null) continue;
                PskPublicInformation pskPublicInformation = identity;
                return pskPublicInformation;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return null;
    }

    @Override
    public void setResultHandler(HandshakeResultHandler resultHandler) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() throws DestroyFailedException {
        this.lock.writeLock().lock();
        try {
            this.destroyed = true;
            this.scopedIdentities.clear();
            for (Map<PskPublicInformation, PskCredentials> keys : this.scopedKeys.values()) {
                for (PskCredentials credentials : keys.values()) {
                    credentials.destroy();
                }
            }
            this.scopedKeys.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    private static PskCredentials getPskCredentials(PskPublicInformation identity, Map<PskPublicInformation, PskCredentials> keyMap) {
        if (keyMap != null) {
            return keyMap.get(identity);
        }
        return null;
    }

    public void setKey(String identity, byte[] key) {
        this.setKey(new PskPublicInformation(identity), key, GLOBAL_SCOPE);
    }

    public void setKey(PskPublicInformation identity, byte[] key) {
        this.setKey(identity, key, GLOBAL_SCOPE);
    }

    public void setKey(String identity, byte[] key, String virtualHost) {
        this.setKey(new PskPublicInformation(identity), key, ServerName.fromHostName(virtualHost));
    }

    public void setKey(PskPublicInformation identity, byte[] key, String virtualHost) {
        this.setKey(identity, key, ServerName.fromHostName(virtualHost));
    }

    public void setKey(String identity, byte[] key, ServerName virtualHost) {
        this.setKey(new PskPublicInformation(identity), key, virtualHost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKey(PskPublicInformation identity, byte[] key, ServerName virtualHost) {
        if (identity == null) {
            throw new NullPointerException("identity must not be null");
        }
        if (key == null) {
            throw new NullPointerException("key must not be null");
        }
        if (virtualHost == null) {
            throw new NullPointerException("serverName must not be null");
        }
        this.lock.writeLock().lock();
        try {
            Map<PskPublicInformation, PskCredentials> keysForServerName = this.scopedKeys.get(virtualHost);
            if (keysForServerName == null) {
                keysForServerName = new ConcurrentHashMap<PskPublicInformation, PskCredentials>();
                this.scopedKeys.put(virtualHost, keysForServerName);
            }
            keysForServerName.put(identity, new PskCredentials(identity, key));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void addKnownPeer(InetSocketAddress peerAddress, String identity, byte[] key) {
        this.addKnownPeer(peerAddress, GLOBAL_SCOPE, new PskPublicInformation(identity), key);
    }

    public void addKnownPeer(InetSocketAddress peerAddress, PskPublicInformation identity, byte[] key) {
        this.addKnownPeer(peerAddress, GLOBAL_SCOPE, identity, key);
    }

    public void addKnownPeer(InetSocketAddress peerAddress, String virtualHost, String identity, byte[] key) {
        this.addKnownPeer(peerAddress, ServerName.fromHostName(virtualHost), new PskPublicInformation(identity), key);
    }

    public void addKnownPeer(InetSocketAddress peerAddress, String virtualHost, PskPublicInformation identity, byte[] key) {
        this.addKnownPeer(peerAddress, ServerName.fromHostName(virtualHost), identity, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addKnownPeer(InetSocketAddress peerAddress, ServerName virtualHost, PskPublicInformation identity, byte[] key) {
        if (peerAddress == null) {
            throw new NullPointerException("peer address must not be null");
        }
        if (virtualHost == null) {
            throw new NullPointerException("virtual host must not be null");
        }
        if (identity == null) {
            throw new NullPointerException("identity must not be null");
        }
        if (key == null) {
            throw new NullPointerException("key must not be null");
        }
        this.lock.writeLock().lock();
        try {
            Map<ServerName, PskPublicInformation> identities = this.scopedIdentities.get(peerAddress);
            if (identities == null) {
                identities = new ConcurrentHashMap<ServerName, PskPublicInformation>();
                this.scopedIdentities.put(peerAddress, identities);
            }
            identities.put(virtualHost, identity);
            this.setKey(identity, key, virtualHost);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void removeKey(String identity) {
        this.removeKey(new PskPublicInformation(identity), GLOBAL_SCOPE);
    }

    public void removeKey(PskPublicInformation identity) {
        this.removeKey(identity, GLOBAL_SCOPE);
    }

    public void removeKey(String identity, String virtualHost) {
        this.removeKey(new PskPublicInformation(identity), ServerName.fromHostName(virtualHost));
    }

    public void removeKey(PskPublicInformation identity, String virtualHost) {
        this.removeKey(identity, ServerName.fromHostName(virtualHost));
    }

    public void removeKey(String identity, ServerName virtualHost) {
        this.removeKey(new PskPublicInformation(identity), virtualHost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKey(PskPublicInformation identity, ServerName virtualHost) {
        if (identity == null) {
            throw new NullPointerException("identity must not be null");
        }
        if (virtualHost == null) {
            throw new NullPointerException("serverName must not be null");
        }
        this.lock.writeLock().lock();
        try {
            Map<PskPublicInformation, PskCredentials> keysForServerName = this.scopedKeys.get(virtualHost);
            if (keysForServerName != null) {
                keysForServerName.remove(identity);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private static PskPublicInformation getIdentityFromMap(ServerName virtualHost, Map<ServerName, PskPublicInformation> identities) {
        if (identities != null) {
            return identities.get(virtualHost);
        }
        return null;
    }

    private static class PskCredentials
    implements Destroyable {
        private final PskPublicInformation identity;
        private final SecretKey key;

        private PskCredentials(PskPublicInformation identity, byte[] key) {
            this.identity = identity;
            this.key = SecretUtil.create(key, "PSK");
        }

        public PskPublicInformation getIdentity() {
            return this.identity;
        }

        public SecretKey getKey() {
            return SecretUtil.create(this.key);
        }

        @Override
        public void destroy() throws DestroyFailedException {
            SecretUtil.destroy(this.key);
        }

        @Override
        public boolean isDestroyed() {
            return SecretUtil.isDestroyed(this.key);
        }
    }
}

