/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests.tests;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.core.Utils;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.plugtests.TestClientAbstract;

public class CO02_05
extends TestClientAbstract {
    public static final String RESOURCE_URI = "/obs-non";
    public final CoAP.ResponseCode EXPECTED_RESPONSE_CODE = CoAP.ResponseCode.CONTENT;

    public CO02_05(String serverURI) {
        super(CO02_05.class.getSimpleName());
        Request request = new Request(CoAP.Code.GET, CoAP.Type.NON);
        request.setObserve();
        this.executeRequest(request, serverURI, RESOURCE_URI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void executeRequest(Request request, String serverURI, String resourceUri) {
        if (!serverURI.endsWith("/") && !resourceUri.startsWith("/")) {
            resourceUri = "/" + resourceUri;
        }
        URI uri = null;
        try {
            uri = new URI(serverURI + resourceUri);
            this.setUseTcp(uri.getScheme());
        }
        catch (URISyntaxException use) {
            throw new IllegalArgumentException("Invalid URI: " + use.getMessage());
        }
        CO02_05.addContextObserver(request);
        request.setURI(uri);
        int observeLoop = 6;
        long time = 5000L;
        if (this.verbose) {
            System.out.println("Request for test " + this.testName + " sent");
            Utils.prettyPrint(request);
        }
        try {
            Response response = null;
            boolean success = true;
            this.startObserve(request);
            System.out.println();
            System.out.println("**** TEST: " + this.testName + " ****");
            System.out.println("**** BEGIN CHECK ****");
            response = request.waitForResponse(time);
            if (response != null) {
                success &= this.checkType(CoAP.Type.NON, response.getType());
                success &= this.checkCode(this.EXPECTED_RESPONSE_CODE, response.getCode());
                success &= this.hasContentType(response);
                success &= this.hasToken(response);
                success &= this.hasObserve(response);
                time = response.getOptions().getMaxAge() * 1000L;
                System.out.println("+++++ Max-Age: " + time + " +++++");
                if (time == 0L) {
                    time = 5000L;
                }
                for (int l = 0; success && l < observeLoop; ++l) {
                    response = this.waitForNotification(time + 1000L);
                    if (response != null) {
                        System.out.println("Received notification " + l);
                        if (this.verbose) {
                            System.out.println("Response received");
                            System.out.println("Time elapsed (ms): " + TimeUnit.NANOSECONDS.toMillis(response.getApplicationRttNanos()));
                            Utils.prettyPrint(response);
                        }
                        success &= this.checkResponse(request, response);
                        continue;
                    }
                    System.out.println("FAIL: missing notification");
                    success = false;
                }
            } else {
                System.out.println("FAIL: No notification after registration");
                success = false;
            }
            System.out.println("+++++++++++++++++++++++");
            System.out.println("++++ SEE WIRESHARK ++++");
            System.out.println("++++  FOR SERVER   ++++");
            System.out.println("++++ CANCELLATION  ++++");
            System.out.println("+++++++++++++++++++++++");
            if (success) {
                System.out.println("**** TEST PASSED ****");
                this.addSummaryEntry(this.testName + ": PASSED (conditionally)");
            } else {
                System.out.println("**** TEST FAILED ****");
                this.addSummaryEntry(this.testName + ": --FAILED--");
            }
            this.tickOffTest();
        }
        catch (InterruptedException e) {
            System.err.println("Interupted during receive: " + e.getMessage());
            System.exit(-1);
        }
        finally {
            this.stopObservation();
        }
    }

    @Override
    protected boolean checkResponse(Request request, Response response) {
        boolean success = true;
        success &= this.checkCode(this.EXPECTED_RESPONSE_CODE, response.getCode());
        success &= this.checkToken(request.getToken(), response.getToken());
        success &= this.hasContentType(response);
        success &= this.hasNonEmptyPayload(response);
        return success &= this.hasObserve(response);
    }
}

