/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests.tests;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.core.Utils;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.plugtests.TestClientAbstract;

public class CC21
extends TestClientAbstract {
    public static final String RESOURCE_URI = "/validate";
    public final CoAP.ResponseCode EXPECTED_RESPONSE_CODE_A = CoAP.ResponseCode.CONTENT;
    public final CoAP.ResponseCode EXPECTED_RESPONSE_CODE_B = CoAP.ResponseCode.VALID;
    public final CoAP.ResponseCode EXPECTED_RESPONSE_CODE_C = CoAP.ResponseCode.CONTENT;
    private byte[] etagStep3;

    public CC21(String serverURI) {
        super(CC21.class.getSimpleName());
        Request request = new Request(CoAP.Code.GET, CoAP.Type.CON);
        this.executeRequest(request, serverURI, RESOURCE_URI);
    }

    @Override
    protected synchronized void executeRequest(Request request, String serverURI, String resourceUri) {
        if (!serverURI.endsWith("/") && !resourceUri.startsWith("/")) {
            resourceUri = "/" + resourceUri;
        }
        URI uri = null;
        try {
            uri = new URI(serverURI + resourceUri);
            this.setUseTcp(uri.getScheme());
        }
        catch (URISyntaxException use) {
            throw new IllegalArgumentException("Invalid URI: " + use.getMessage());
        }
        request.setURI(uri);
        CC21.addContextObserver(request);
        if (this.verbose) {
            System.out.println("Request for test " + this.testName + " sent");
            Utils.prettyPrint(request);
        }
        try {
            Response response = null;
            boolean success = true;
            System.out.println();
            System.out.println("**** TEST: " + this.testName + " ****");
            System.out.println("**** BEGIN CHECK ****");
            request.send();
            response = request.waitForResponse(6000L);
            if (response != null) {
                if (this.verbose) {
                    System.out.println("Response received");
                    System.out.println("Time elapsed (ms): " + TimeUnit.NANOSECONDS.toMillis(response.getApplicationRttNanos()));
                    Utils.prettyPrint(response);
                }
                success &= this.checkType(CoAP.Type.ACK, response.getType());
                success &= this.checkCode(this.EXPECTED_RESPONSE_CODE_A, response.getCode());
                success &= this.hasEtag(response);
                success &= this.hasNonEmptyPayload(response);
                this.etagStep3 = response.getOptions().getETags().get(0);
                request = new Request(CoAP.Code.GET, CoAP.Type.CON);
                request.getOptions().addETag(this.etagStep3);
                CC21.addContextObserver(request);
                request.setURI(uri);
                request.send();
                response = request.waitForResponse(6000L);
                if (response != null) {
                    if (this.verbose) {
                        System.out.println("Response received");
                        System.out.println("Time elapsed (ms): " + TimeUnit.NANOSECONDS.toMillis(response.getApplicationRttNanos()));
                        Utils.prettyPrint(response);
                    }
                    success &= this.checkType(CoAP.Type.ACK, response.getType());
                    success &= this.checkCode(this.EXPECTED_RESPONSE_CODE_B, response.getCode());
                    success &= this.hasEtag(response);
                    success &= this.checkOption(this.etagStep3, response.getOptions().getETags().get(0), "ETag");
                    request = new Request(CoAP.Code.PUT, CoAP.Type.CON);
                    CC21.addContextObserver(request);
                    request.setURI(uri);
                    request.setPayload("It should change");
                    request.getOptions().setContentFormat(0);
                    request.send();
                    Thread.sleep(1000L);
                    request = new Request(CoAP.Code.GET, CoAP.Type.CON);
                    request.getOptions().addETag(this.etagStep3);
                    CC21.addContextObserver(request);
                    request.setURI(uri);
                    request.send();
                    response = request.waitForResponse(6000L);
                    if (response != null) {
                        if (this.verbose) {
                            System.out.println("Response received");
                            System.out.println("Time elapsed (ms): " + TimeUnit.NANOSECONDS.toMillis(response.getApplicationRttNanos()));
                            Utils.prettyPrint(response);
                        }
                        success &= this.checkType(CoAP.Type.ACK, response.getType());
                        success &= this.checkCode(this.EXPECTED_RESPONSE_CODE_C, response.getCode());
                        success &= this.hasEtag(response);
                        success &= this.checkDifferentOption(this.etagStep3, response.getOptions().getETags().get(0), "ETag");
                    }
                }
            }
            if (success) {
                System.out.println("**** TEST PASSED ****");
                this.addSummaryEntry(this.testName + ": PASSED");
            } else {
                System.out.println("**** TEST FAILED ****");
                this.addSummaryEntry(this.testName + ": --FAILED--");
            }
            this.tickOffTest();
        }
        catch (InterruptedException e) {
            System.err.println("Interupted during receive: " + e.getMessage());
            System.exit(-1);
        }
    }

    @Override
    protected boolean checkResponse(Request request, Response response) {
        return false;
    }
}

