/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap;

import java.util.Arrays;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.MediaTypeRegistry;
import org.eclipse.californium.core.coap.OptionNumberRegistry;

public class Option
implements Comparable<Option> {
    private int number;
    private byte[] value;

    public Option() {
        this.value = new byte[0];
    }

    public Option(int number) {
        this.number = number;
        this.value = new byte[0];
    }

    public Option(int number, String str) {
        this.number = number;
        this.setStringValue(str);
    }

    public Option(int number, int val) {
        this.number = number;
        this.setIntegerValue(val);
    }

    public Option(int number, long val) {
        this.number = number;
        this.setLongValue(val);
    }

    public Option(int number, byte[] opaque) {
        this.number = number;
        this.setValue(opaque);
    }

    public int getLength() {
        return this.value.length;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public byte[] getValue() {
        return this.value;
    }

    public String getStringValue() {
        return new String(this.value, CoAP.UTF8_CHARSET);
    }

    public int getIntegerValue() {
        int ret = 0;
        for (int i = 0; i < this.value.length; ++i) {
            ret += (this.value[this.value.length - i - 1] & 0xFF) << i * 8;
        }
        return ret;
    }

    public long getLongValue() {
        long ret = 0L;
        for (int i = 0; i < this.value.length; ++i) {
            ret += (long)((this.value[this.value.length - i - 1] & 0xFF) << i * 8);
        }
        return ret;
    }

    public void setValue(byte[] value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.value = value;
    }

    public void setStringValue(String str) {
        if (str == null) {
            throw new NullPointerException();
        }
        this.value = str.getBytes(CoAP.UTF8_CHARSET);
    }

    public void setIntegerValue(int val) {
        int i;
        int length = 0;
        for (i = 0; i < 4 && (val >= 1 << i * 8 || val < 0); ++i) {
            ++length;
        }
        this.value = new byte[length];
        for (i = 0; i < length; ++i) {
            this.value[length - i - 1] = (byte)(val >> i * 8);
        }
    }

    public void setLongValue(long val) {
        int i;
        int length = 0;
        for (i = 0; i < 8 && (val >= 1L << i * 8 || val < 0L); ++i) {
            ++length;
        }
        this.value = new byte[length];
        for (i = 0; i < length; ++i) {
            this.value[length - i - 1] = (byte)(val >> i * 8);
        }
    }

    public boolean isCritical() {
        return (this.number & 1) != 0;
    }

    public boolean isUnSafe() {
        return (this.number & 2) != 0;
    }

    public boolean isNoCacheKey() {
        return (this.number & 0x1E) == 28;
    }

    @Override
    public int compareTo(Option o) {
        return this.number - o.number;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Option)) {
            return false;
        }
        Option op = (Option)o;
        return this.number == op.number && Arrays.equals(this.value, op.value);
    }

    public int hashCode() {
        return this.number * 31 + this.value.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OptionNumberRegistry.toString(this.number));
        sb.append(": ");
        sb.append(this.toValueString());
        return sb.toString();
    }

    public String toValueString() {
        switch (OptionNumberRegistry.getFormatByNr(this.number)) {
            case INTEGER: {
                if (this.number == 17 || this.number == 12) {
                    return "\"" + MediaTypeRegistry.toString(this.getIntegerValue()) + "\"";
                }
                return Integer.toString(this.getIntegerValue());
            }
            case STRING: {
                return "\"" + this.getStringValue() + "\"";
            }
        }
        return this.toHexString(this.getValue());
    }

    private String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        sb.append("0x");
        for (byte b : bytes) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString();
    }
}

