/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap;

public final class OptionNumberRegistry {
    public static final int DEFAULT_MAX_AGE = 60;
    public static final int RESERVED_0 = 0;
    public static final int IF_MATCH = 1;
    public static final int URI_HOST = 3;
    public static final int ETAG = 4;
    public static final int IF_NONE_MATCH = 5;
    public static final int URI_PORT = 7;
    public static final int LOCATION_PATH = 8;
    public static final int URI_PATH = 11;
    public static final int CONTENT_TYPE = 12;
    public static final int MAX_AGE = 14;
    public static final int URI_QUERY = 15;
    public static final int ACCEPT = 16;
    public static final int LOCATION_QUERY = 20;
    public static final int PROXY_URI = 35;
    public static final int PROXY_SCHEME = 39;
    public static final int OBSERVE = 6;
    public static final int BLOCK2 = 23;
    public static final int BLOCK1 = 27;
    public static final int SIZE = 28;
    public static final int TOKEN_LEN = 8;
    public static final int ETAG_LEN = 8;

    public static optionFormats getFormatByNr(int optionNumber) {
        switch (optionNumber) {
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 14: 
            case 16: 
            case 23: 
            case 27: 
            case 28: {
                return optionFormats.INTEGER;
            }
            case 3: 
            case 8: 
            case 11: 
            case 15: 
            case 20: 
            case 35: 
            case 39: {
                return optionFormats.STRING;
            }
            case 1: 
            case 4: {
                return optionFormats.OPAQUE;
            }
        }
        return optionFormats.UNKNOWN;
    }

    public static boolean isCritical(int optionNumber) {
        return (optionNumber & 1) > 1;
    }

    public static boolean isElective(int optionNumber) {
        return (optionNumber & 1) == 0;
    }

    public static boolean isUnsafe(int optionNumber) {
        return (optionNumber & 2) > 0;
    }

    public static boolean isSafe(int optionNumber) {
        return !OptionNumberRegistry.isUnsafe(optionNumber);
    }

    public static boolean isNoCacheKey(int optionNumber) {
        return (optionNumber & 0x1E) == 28;
    }

    public static boolean isCacheKey(int optionNumber) {
        return !OptionNumberRegistry.isNoCacheKey(optionNumber);
    }

    public static boolean isSingleValue(int optionNumber) {
        switch (optionNumber) {
            case 3: 
            case 5: 
            case 7: 
            case 12: 
            case 14: 
            case 35: 
            case 39: {
                return true;
            }
        }
        return false;
    }

    public static boolean isUriOption(int optionNumber) {
        boolean result = optionNumber == 3 || optionNumber == 11 || optionNumber == 7 || optionNumber == 15;
        return result;
    }

    public static String toString(int optionNumber) {
        switch (optionNumber) {
            case 0: {
                return "Reserved (0)";
            }
            case 12: {
                return "Content-Type";
            }
            case 14: {
                return "Max-Age";
            }
            case 35: {
                return "Proxy-Uri";
            }
            case 4: {
                return "ETag";
            }
            case 3: {
                return "Uri-Host";
            }
            case 8: {
                return "Location-Path";
            }
            case 7: {
                return "Uri-Port";
            }
            case 20: {
                return "Location-Query";
            }
            case 11: {
                return "Uri-Path";
            }
            case 6: {
                return "Observe";
            }
            case 16: {
                return "Accept";
            }
            case 1: {
                return "If-Match";
            }
            case 15: {
                return "Uri-Query";
            }
            case 23: {
                return "Block2";
            }
            case 27: {
                return "Block1";
            }
            case 28: {
                return "Size";
            }
            case 5: {
                return "If-None-Match";
            }
            case 39: {
                return "Proxy-Scheme";
            }
        }
        return String.format("Unknown option [%d]", optionNumber);
    }

    private OptionNumberRegistry() {
    }

    public static enum optionFormats {
        INTEGER,
        STRING,
        OPAQUE,
        UNKNOWN;

    }
}

