/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.util.encrypt;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECKey;
import java.security.spec.EllipticCurve;
import java.util.Arrays;
import org.eclipse.californium.elements.util.SslContextUtil;
import org.eclipse.californium.elements.util.StringUtil;

public class Dump {
    private static void usage() {
        System.out.println("usage:  [(--private-key|--public-key)] [(--hex|--base64)] [--raw] <file>");
        System.out.println("       --private-key  : dump private key");
        System.out.println("       --public-key   : dump public key (default)");
        System.out.println("       --hex          : dump key in hexadecimal");
        System.out.println("       --base64       : dump key in base 64 (default)");
        System.out.println("       --raw          : dump raw key (skip ASN.1 header).");
    }

    public static void main(String[] args) {
        try {
            boolean raw = false;
            Boolean mode = null;
            Boolean encoding = null;
            String file = null;
            for (int index = 0; index < args.length; ++index) {
                if (args[index].equals("--private-key")) {
                    if (mode != null && !mode.booleanValue()) {
                        throw new IllegalArgumentException("--public-key also provided!");
                    }
                    mode = true;
                    continue;
                }
                if (args[index].equals("--public-key")) {
                    if (mode != null && mode.booleanValue()) {
                        throw new IllegalArgumentException("--private-key also provided!");
                    }
                    mode = false;
                    continue;
                }
                if (args[index].equals("--hex")) {
                    if (encoding != null && !encoding.booleanValue()) {
                        throw new IllegalArgumentException("--base64 also provided!");
                    }
                    encoding = true;
                    continue;
                }
                if (args[index].equals("--base64")) {
                    if (encoding != null && encoding.booleanValue()) {
                        throw new IllegalArgumentException("--hex also provided!");
                    }
                    encoding = false;
                    continue;
                }
                if (args[index].equals("--raw")) {
                    raw = true;
                    continue;
                }
                if (file != null) {
                    throw new IllegalArgumentException("file already provided!");
                }
                file = args[index];
            }
            if (file != null) {
                byte[] key = null;
                if (Boolean.TRUE == mode) {
                    PrivateKey privateKey = SslContextUtil.loadPrivateKey(file, null, null, null);
                    key = privateKey.getEncoded();
                    if (raw && privateKey instanceof ECKey) {
                        int keySize = Dump.getKeySize((ECKey)((Object)privateKey));
                        key = Arrays.copyOfRange(key, key.length - keySize, key.length);
                    }
                } else {
                    PublicKey publicKey = SslContextUtil.loadPublicKey(file, null, null);
                    key = publicKey.getEncoded();
                    if (raw && publicKey instanceof ECKey) {
                        int keySize = Dump.getKeySize((ECKey)((Object)publicKey));
                        key = Arrays.copyOfRange(key, key.length - keySize * 2, key.length);
                    }
                }
                if (key != null) {
                    if (Boolean.TRUE == encoding) {
                        System.out.println(":0x" + StringUtil.byteArray2Hex(key));
                    } else {
                        System.out.println(StringUtil.byteArrayToBase64(key));
                    }
                }
                return;
            }
            System.err.println("Misssing file!");
        }
        catch (GeneralSecurityException x) {
            System.err.println(x.getMessage());
        }
        catch (ArrayIndexOutOfBoundsException x) {
            System.err.println("Misssing parameter for " + args[args.length - 1]);
        }
        catch (IllegalArgumentException x) {
            System.err.println(x.getMessage());
        }
        catch (FileNotFoundException e) {
            System.err.println(e.getMessage());
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
        Dump.usage();
        System.exit(1);
    }

    private static int getKeySize(ECKey key) {
        EllipticCurve curve = key.getParams().getCurve();
        return (curve.getField().getFieldSize() + 8 - 1) / 8;
    }
}

