/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.concurrent.ThreadFactory;
import java.util.function.BooleanSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NetworkStageRunnable
implements Runnable {
    private final Logger LOGGER;
    private final BooleanSupplier running;
    private volatile String name;

    public NetworkStageRunnable(BooleanSupplier running, Class<?> logger) {
        this.LOGGER = LoggerFactory.getLogger(logger);
        this.running = running;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void run() {
        try {
            this.LOGGER.info("Network stage thread [{}] started", (Object)this.getName());
            while (this.running.getAsBoolean()) {
                try {
                    this.work();
                }
                catch (SocketTimeoutException e) {
                    this.LOGGER.trace("Network stage thread [{}] socket timeout", (Object)this.getName(), (Object)e);
                }
                catch (InterruptedIOException e) {
                    if (this.running.getAsBoolean()) {
                        this.LOGGER.info("Network stage thread [{}] I/O has been interrupted", (Object)this.getName());
                        continue;
                    }
                    this.LOGGER.debug("Network stage thread [{}] I/O has been interrupted", (Object)this.getName());
                }
                catch (InterruptedException e) {
                    if (this.running.getAsBoolean()) {
                        this.LOGGER.info("Network stage thread [{}] has been interrupted", (Object)this.getName());
                        continue;
                    }
                    this.LOGGER.debug("Network stage thread [{}] has been interrupted", (Object)this.getName());
                }
                catch (Exception e) {
                    if (this.running.getAsBoolean()) {
                        this.LOGGER.debug("Exception thrown by Network stage thread [{}]", (Object)this.getName(), (Object)e);
                        continue;
                    }
                    this.LOGGER.trace("Exception thrown by Network stage thread [{}]", (Object)this.getName(), (Object)e);
                }
            }
        }
        finally {
            if (this.running.getAsBoolean()) {
                this.LOGGER.info("Network stage thread [{}] has terminated", (Object)this.getName());
            } else {
                this.LOGGER.debug("Network stage thread [{}] has terminated", (Object)this.getName());
            }
        }
    }

    protected abstract void work() throws Exception;

    public Thread attach(ThreadFactory factory, boolean start) {
        Thread thread = factory.newThread(this);
        this.setName(thread.getName());
        if (start) {
            thread.start();
        }
        return thread;
    }
}

