/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.util.encrypt;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.californium.elements.util.EncryptedStreamUtil;
import org.eclipse.californium.elements.util.StringUtil;

public class Encrypt {
    private static void usage() {
        String jceCipher = null;
        try {
            EncryptedStreamUtil util = new EncryptedStreamUtil();
            jceCipher = "(\"" + util.getWriteCipher() + "\" is supported by this JCE.)";
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.out.println("usage:  --password64 <password-base64>");
        System.out.println("        [(--encrypt [--cipher <cipher>]|--decrypt)]");
        System.out.println("        [--out <file>] [--in] <file>");
        System.out.println("       --password64   : password base 64 encoded");
        System.out.println("       --encrypt      : encrypt file. Default mode.");
        System.out.println("         --cipher     : cipher to encrypt file. Default \"AES/GCM/128\" or ");
        System.out.println("                        \"AES/CBC/128\", if GCM is not supported by the JCE.");
        if (jceCipher != null) {
            System.out.println("                        " + jceCipher);
        }
        System.out.println("       --decrypt      : decrypt file");
        System.out.println("       --out          : output file name. Default replaces input file.");
        System.out.println("       --in           : input file name.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block37: {
            try {
                String cipher = null;
                File file = null;
                File out = null;
                File temp = null;
                SecretKeySpec password = null;
                Boolean encrypt = null;
                for (int index = 0; index < args.length; ++index) {
                    if (args[index].equals("--password64")) {
                        if (password != null) {
                            throw new IllegalArgumentException("--password64 already provided!");
                        }
                        password = new SecretKeySpec(StringUtil.base64ToByteArray(args[++index]), "PASSWORD");
                        continue;
                    }
                    if (args[index].equals("--out")) {
                        if (out != null) {
                            throw new IllegalArgumentException("--out already provided!");
                        }
                        out = new File(args[++index]);
                        continue;
                    }
                    if (args[index].equals("--cipher")) {
                        if (cipher != null) {
                            throw new IllegalArgumentException("--cipher already provided!");
                        }
                        cipher = args[++index];
                        continue;
                    }
                    if (args[index].equals("--encrypt")) {
                        if (encrypt != null) {
                            throw new IllegalArgumentException("--encrypt or --decrypt already provided!");
                        }
                        encrypt = true;
                        continue;
                    }
                    if (args[index].equals("--decrypt")) {
                        if (encrypt != null) {
                            throw new IllegalArgumentException("--encrypt or --decrypt already provided!");
                        }
                        encrypt = false;
                        continue;
                    }
                    if (args[index].equals("--in")) {
                        if (file != null) {
                            throw new IllegalArgumentException("file already provided!");
                        }
                        file = new File(args[++index]);
                        continue;
                    }
                    if (args[index].startsWith("--")) {
                        throw new IllegalArgumentException(args[index] + " not supported!");
                    }
                    if (file != null) {
                        throw new IllegalArgumentException("file already provided!");
                    }
                    file = new File(args[index]);
                }
                if (password == null) {
                    System.err.println("Misssing --password64");
                    break block37;
                }
                if (file == null) {
                    System.err.println("Misssing [--in] file");
                    break block37;
                }
                EncryptedStreamUtil util = new EncryptedStreamUtil();
                if (encrypt == null) {
                    encrypt = true;
                }
                if (!encrypt.booleanValue() && cipher != null) {
                    throw new IllegalArgumentException("Provided cipher " + cipher + " is ignored with decrypt!");
                }
                if (out == null) {
                    out = temp = Encrypt.createUnique(file, ".temp");
                }
                String mode = encrypt != false ? "Encrypted " : "Decrypted ";
                OutputStream os = null;
                InputStream is = null;
                try {
                    os = new FileOutputStream(out);
                    is = new FileInputStream(file);
                    if (encrypt.booleanValue()) {
                        if (cipher != null) {
                            util.setWriteCipher(cipher);
                        } else {
                            cipher = util.getWriteCipher();
                        }
                        os = util.prepare(os, (SecretKey)password);
                    } else {
                        is = util.prepare(is, (SecretKey)password);
                        cipher = util.getReadCipher();
                    }
                    byte[] buffer = new byte[0x100000];
                    int len = 0;
                    while ((len = is.read(buffer)) >= 0) {
                        if (len <= 0) continue;
                        os.write(buffer, 0, len);
                    }
                }
                finally {
                    if (os != null) {
                        os.close();
                    }
                    if (is != null) {
                        is.close();
                    }
                }
                long size = file.length();
                if (temp != null) {
                    File backup = Encrypt.createUnique(file, ".orig");
                    file.renameTo(backup);
                    temp.renameTo(file);
                    System.out.println(mode + size + " bytes in " + file + " using " + cipher);
                } else {
                    System.out.println(mode + size + " bytes from " + file + " to " + out + " using " + cipher);
                }
                return;
            }
            catch (ArrayIndexOutOfBoundsException x) {
                System.err.println("Misssing parameter for " + args[args.length - 1]);
            }
            catch (IllegalArgumentException x) {
                System.err.println(x.getMessage());
            }
            catch (FileNotFoundException e) {
                System.err.println(e.getMessage());
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
        }
        Encrypt.usage();
        System.exit(1);
    }

    private static File createUnique(File file, String ending) {
        int index = 1;
        File result = new File(file.getPath() + ending);
        while (result.exists()) {
            result = new File(file.getPath() + ending + "." + index++);
        }
        return result;
    }
}

