/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.californium.elements.config.BasicListDefinition;
import org.eclipse.californium.elements.config.DefinitionUtils;
import org.eclipse.californium.elements.config.ValueException;

public class EnumListDefinition<E extends Enum<?>>
extends BasicListDefinition<E> {
    private final List<E> defaultValue;
    private final Class<E> itemType;
    private final String typeName;
    private final List<E> values;
    private final String valuesDocumentation;
    private final int minimumItems;

    public EnumListDefinition(String key, String documentation, E[] values) {
        this(key, documentation, null, 0, (Enum[])values);
    }

    public EnumListDefinition(String key, String documentation, List<E> defaultValue, E[] values) {
        this(key, documentation, defaultValue, 0, (Enum[])values);
    }

    public EnumListDefinition(String key, String documentation, List<E> defaultValue, int minimumItems, E[] values) {
        super(key, documentation, null);
        if (values == null) {
            throw new NullPointerException("Enum set must not be null!");
        }
        if (values.length == 0) {
            throw new IllegalArgumentException("Enum set must not be empty!");
        }
        for (E in : values) {
            if (in != null) continue;
            throw new IllegalArgumentException("Enum set must not contain null!");
        }
        this.itemType = values[0].getClass();
        this.typeName = "List<" + this.itemType.getSimpleName() + ">";
        this.values = Arrays.asList(Arrays.copyOf(values, values.length));
        this.valuesDocumentation = DefinitionUtils.toNames(this.values, true);
        this.minimumItems = minimumItems;
        try {
            this.defaultValue = this.checkValue(defaultValue);
        }
        catch (ValueException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public String writeValue(List<E> value) {
        return DefinitionUtils.toNames(value, false);
    }

    @Override
    public List<E> checkValue(List<E> value) throws ValueException {
        if (value != null) {
            if (value.size() < this.minimumItems) {
                if (value.isEmpty()) {
                    throw new ValueException("Values must not be empty!");
                }
                throw new ValueException("Values with " + value.size() + " items must not contain less items than " + this.minimumItems + "!");
            }
            for (Enum item : value) {
                if (this.values.contains(item)) continue;
                if (this.itemType.isInstance(item)) {
                    throw new IllegalArgumentException(item + " is not in " + this.valuesDocumentation);
                }
                throw new IllegalArgumentException(item + " is no " + this.itemType.getSimpleName());
            }
        }
        return super.checkValue(value);
    }

    @Override
    public List<E> getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getDocumentation() {
        return super.getDocumentation() + "\nList of " + this.valuesDocumentation + ".";
    }

    @Override
    protected boolean isAssignableFrom(Object value) {
        if (value instanceof List) {
            for (Object item : (List)value) {
                if (this.itemType.isInstance(item)) continue;
                throw new IllegalArgumentException(item + " is no " + this.itemType.getSimpleName());
            }
            return true;
        }
        return false;
    }

    @Override
    protected List<E> parseValue(String value) throws ValueException {
        String[] list = value.split(",");
        ArrayList<E> result = new ArrayList<E>(list.length);
        for (String valueItem : list) {
            E elementitem = DefinitionUtils.toValue(valueItem = valueItem.trim(), this.values);
            if (elementitem == null) {
                throw new ValueException(valueItem + " is not in " + this.valuesDocumentation);
            }
            result.add(elementitem);
        }
        return result;
    }
}

