/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.examples;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import org.eclipse.californium.core.CaliforniumLogger;
import org.eclipse.californium.core.CoapClient;
import org.eclipse.californium.core.CoapHandler;
import org.eclipse.californium.core.CoapResponse;
import org.eclipse.californium.core.network.CoAPEndpoint;
import org.eclipse.californium.core.network.EndpointManager;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.network.stack.congestioncontrol.Cocoa;

public class CocoaClient {
    public static void main(String[] args) {
        URI uri = null;
        try {
            uri = args.length > 0 ? new URI(args[0]) : new URI("coap://iot.eclipse.org/test");
        }
        catch (URISyntaxException e) {
            System.err.println("Invalid URI: " + e.getMessage());
            System.exit(-1);
        }
        NetworkConfig config = new NetworkConfig().setBoolean("USE_CONGESTION_CONTROL", true).setString("CONGESTION_CONTROL_ALGORITHM", Cocoa.class.getSimpleName()).setInt("NSTART", 4);
        CoAPEndpoint cocoaEndpoint = new CoAPEndpoint(config);
        EndpointManager.getEndpointManager().setDefaultEndpoint(cocoaEndpoint);
        CoapClient client = new CoapClient(uri);
        int NUMBER = 50;
        final Semaphore semaphore = new Semaphore(0);
        for (int i = 0; i < 50; ++i) {
            client.get(new CoapHandler(){

                @Override
                public void onLoad(CoapResponse response) {
                    semaphore.release();
                    System.out.println("Received " + semaphore.availablePermits());
                }

                @Override
                public void onError() {
                    System.out.println("Failed");
                }
            });
        }
        try {
            semaphore.acquire(50);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    static {
        CaliforniumLogger.initialize();
        CaliforniumLogger.setLevel(Level.CONFIG);
    }
}

