/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.deduplication;

import java.util.logging.Logger;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.network.deduplication.CropRotation;
import org.eclipse.californium.core.network.deduplication.Deduplicator;
import org.eclipse.californium.core.network.deduplication.NoDeduplicator;
import org.eclipse.californium.core.network.deduplication.SweepDeduplicator;

public class DeduplicatorFactory {
    private static final Logger LOGGER = Logger.getLogger(DeduplicatorFactory.class.getCanonicalName());
    private static DeduplicatorFactory factory;

    public static DeduplicatorFactory getDeduplicatorFactory() {
        if (factory == null) {
            factory = new DeduplicatorFactory();
        }
        return factory;
    }

    public static void setDeduplicatorFactory(DeduplicatorFactory factory) {
        DeduplicatorFactory.factory = factory;
    }

    public Deduplicator createDeduplicator(NetworkConfig config) {
        String type = config.getString("DEDUPLICATOR");
        if ("DEDUPLICATOR_MARK_AND_SWEEP".equals(type)) {
            return new SweepDeduplicator(config);
        }
        if ("DEDUPLICATOR_CROP_ROTATION".equals(type)) {
            return new CropRotation(config);
        }
        if ("NO_DEDUPLICATOR".equals(type)) {
            return new NoDeduplicator();
        }
        LOGGER.warning("Unknown deduplicator type: " + type);
        return new NoDeduplicator();
    }
}

