/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network;

import java.net.InetAddress;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.RemoteEndpoint;
import org.eclipse.californium.core.network.config.NetworkConfig;

public class RemoteEndpointManager {
    private final int MAX_REMOTE_ENDPOINTS = 10;
    private LimitedRemoteEndpointHashmap<InetAddress, RemoteEndpoint> remoteEndpointsList = new LimitedRemoteEndpointHashmap(10);
    private NetworkConfig config;

    public RemoteEndpointManager(NetworkConfig config) {
        this.config = config;
    }

    public RemoteEndpoint getRemoteEndpoint(Exchange exchange) {
        InetAddress remoteAddress = exchange.getRequest().getDestination();
        int remotePort = exchange.getRequest().getDestinationPort();
        if (!this.remoteEndpointsList.containsKey(remoteAddress)) {
            RemoteEndpoint unusedRemoteEndpoint = new RemoteEndpoint(remotePort, remoteAddress, this.config);
            this.remoteEndpointsList.put(remoteAddress, unusedRemoteEndpoint);
        }
        return (RemoteEndpoint)this.remoteEndpointsList.get(remoteAddress);
    }

    public class LimitedRemoteEndpointHashmap<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = -7855412701242966797L;
        private final int maxSize;

        public LimitedRemoteEndpointHashmap(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.maxSize;
        }
    }
}

