/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.util;

import java.security.MessageDigest;
import java.security.spec.KeySpec;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.scandium.util.SecretIvParameterSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecretUtil.class);

    public static void destroy(Destroyable destroyable) {
        if (destroyable != null) {
            try {
                destroyable.destroy();
            }
            catch (DestroyFailedException e) {
                LOGGER.warn("Destroy on {} failed!", (Object)destroyable.getClass(), (Object)e);
            }
        }
    }

    public static boolean isDestroyed(Destroyable destroyable) {
        return destroyable == null || destroyable.isDestroyed();
    }

    public static SecretKey create(byte[] secret, String algorithm) {
        return new DestroyableSecretKeySpec(secret, algorithm);
    }

    public static SecretKey create(byte[] secret, int offset, int length, String algorithm) {
        return new DestroyableSecretKeySpec(secret, offset, length, algorithm);
    }

    public static SecretKey create(SecretKey key) {
        DestroyableSecretKeySpec result = null;
        if (key != null) {
            byte[] secret = key.getEncoded();
            result = new DestroyableSecretKeySpec(secret, key.getAlgorithm());
            Bytes.clear(secret);
        }
        return result;
    }

    public static SecretIvParameterSpec createIv(SecretIvParameterSpec iv) {
        SecretIvParameterSpec result = null;
        if (iv != null) {
            result = new SecretIvParameterSpec(iv);
        }
        return result;
    }

    public static SecretIvParameterSpec createIv(byte[] iv, int offset, int length) {
        return new SecretIvParameterSpec(iv, offset, length);
    }

    public static SecretIvParameterSpec createIv(byte[] iv) {
        return new SecretIvParameterSpec(iv, 0, iv.length);
    }

    public static boolean equals(SecretKey key1, SecretKey key2) {
        if (key1 == key2) {
            return true;
        }
        if (key1 == null || key2 == null) {
            return false;
        }
        if (!key1.getAlgorithm().equals(key2.getAlgorithm())) {
            return false;
        }
        byte[] secret1 = key1.getEncoded();
        byte[] secret2 = key2.getEncoded();
        boolean ok = Arrays.equals(secret1, secret2);
        Bytes.clear(secret1);
        Bytes.clear(secret2);
        return ok;
    }

    private static class DestroyableSecretKeySpec
    implements KeySpec,
    SecretKey,
    Destroyable {
        private static final long serialVersionUID = 6578238307397289933L;
        private final int hashCode;
        private final byte[] key;
        private final String algorithm;
        private volatile boolean destroyed;

        private DestroyableSecretKeySpec(byte[] key, String algorithm) {
            this(key, 0, key == null ? 0 : key.length, algorithm);
        }

        private DestroyableSecretKeySpec(byte[] key, int offset, int len, String algorithm) {
            if (key == null) {
                throw new NullPointerException("Key missing");
            }
            if (algorithm == null) {
                throw new NullPointerException("Algorithm missing");
            }
            if (key.length == 0) {
                throw new IllegalArgumentException("Empty key");
            }
            if (key.length - offset < len) {
                throw new IllegalArgumentException("Invalid offset/length combination");
            }
            if (len < 0) {
                throw new ArrayIndexOutOfBoundsException("len is negative");
            }
            this.key = Arrays.copyOfRange(key, offset, offset + len);
            this.algorithm = algorithm;
            this.hashCode = this.calcHashCode();
        }

        private int calcHashCode() {
            return this.hashCode;
        }

        @Override
        public String getAlgorithm() {
            return this.algorithm;
        }

        @Override
        public String getFormat() {
            return "RAW";
        }

        @Override
        public byte[] getEncoded() {
            if (this.destroyed) {
                throw new IllegalStateException("secret destroyed!");
            }
            return (byte[])this.key.clone();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SecretKey)) {
                return false;
            }
            SecretKey other = (SecretKey)obj;
            if (!this.algorithm.equalsIgnoreCase(other.getAlgorithm())) {
                return false;
            }
            if (this.destroyed) {
                throw new IllegalStateException("secret destroyed!");
            }
            byte[] otherKey = other.getEncoded();
            boolean result = MessageDigest.isEqual(this.key, otherKey);
            Bytes.clear(otherKey);
            return result;
        }

        @Override
        public void destroy() throws DestroyFailedException {
            Bytes.clear(this.key);
            this.destroyed = true;
        }

        @Override
        public boolean isDestroyed() {
            return this.destroyed;
        }
    }
}

