/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.NoPublicAPI;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.HelloExtension;

@NoPublicAPI
public class SupportedPointFormatsExtension
extends HelloExtension {
    private static final int LIST_LENGTH_BITS = 8;
    private static final int POINT_FORMAT_BITS = 8;
    private static final List<ECPointFormat> EC_POINT_FORMATS = Collections.singletonList(ECPointFormat.UNCOMPRESSED);
    public static final SupportedPointFormatsExtension DEFAULT_POINT_FORMATS_EXTENSION = new SupportedPointFormatsExtension(EC_POINT_FORMATS);
    private final List<ECPointFormat> ecPointFormatList;

    private SupportedPointFormatsExtension(List<ECPointFormat> ecPointFormatList) {
        super(HelloExtension.ExtensionType.EC_POINT_FORMATS);
        this.ecPointFormatList = ecPointFormatList;
    }

    public boolean contains(ECPointFormat format) {
        return this.ecPointFormatList.contains((Object)format);
    }

    @Override
    public String toString(int indent) {
        StringBuilder sb = new StringBuilder(super.toString(indent));
        String indentation = StringUtil.indentation(indent + 1);
        String indentation2 = StringUtil.indentation(indent + 2);
        sb.append(indentation).append("Elliptic Curves Point Formats (").append(this.ecPointFormatList.size()).append(" formats):").append(StringUtil.lineSeparator());
        for (ECPointFormat format : this.ecPointFormatList) {
            sb.append(indentation2).append("EC point format: ").append((Object)format).append(StringUtil.lineSeparator());
        }
        return sb.toString();
    }

    @Override
    protected int getExtensionLength() {
        return 1 + this.ecPointFormatList.size();
    }

    @Override
    protected void writeExtensionTo(DatagramWriter writer) {
        writer.write(this.ecPointFormatList.size(), 8);
        for (ECPointFormat format : this.ecPointFormatList) {
            writer.write(format.getId(), 8);
        }
    }

    public static HelloExtension fromExtensionDataReader(DatagramReader extensionDataReader) {
        ArrayList<ECPointFormat> ecPointFormatList = new ArrayList<ECPointFormat>();
        int listLength = extensionDataReader.read(8);
        DatagramReader rangeReader = extensionDataReader.createRangeReader(listLength);
        while (rangeReader.bytesAvailable()) {
            ECPointFormat format = ECPointFormat.getECPointFormatById(rangeReader.read(8));
            if (format == null) continue;
            ecPointFormatList.add(format);
        }
        if (ecPointFormatList.size() == 1 && ecPointFormatList.contains((Object)ECPointFormat.UNCOMPRESSED)) {
            return DEFAULT_POINT_FORMATS_EXTENSION;
        }
        return new SupportedPointFormatsExtension(ecPointFormatList);
    }

    public static enum ECPointFormat {
        UNCOMPRESSED(0),
        ANSIX962_COMPRESSED_PRIME(1),
        ANSIX962_COMPRESSED_CHAR2(2);

        private final int id;

        private ECPointFormat(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public String toString() {
            switch (this.id) {
                case 0: {
                    return "uncompressed (" + this.id + ")";
                }
                case 1: {
                    return "ansiX962_compressed_prime (" + this.id + ")";
                }
                case 2: {
                    return "ansiX962_compressed_char2 (" + this.id + ")";
                }
            }
            return "";
        }

        public static ECPointFormat getECPointFormatById(int id) {
            switch (id) {
                case 0: {
                    return UNCOMPRESSED;
                }
                case 1: {
                    return ANSIX962_COMPRESSED_PRIME;
                }
                case 2: {
                    return ANSIX962_COMPRESSED_CHAR2;
                }
            }
            return null;
        }
    }
}

