/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.HandshakeResult;
import org.eclipse.californium.scandium.dtls.PskPublicInformation;
import org.eclipse.californium.scandium.dtls.cipher.PseudoRandomFunction;
import org.eclipse.californium.scandium.dtls.cipher.ThreadLocalCryptoMap;
import org.eclipse.californium.scandium.dtls.cipher.ThreadLocalMac;
import org.eclipse.californium.scandium.util.SecretUtil;

public class PskSecretResult
extends HandshakeResult
implements Destroyable {
    public static final String ALGORITHM_PSK = "PSK";
    public static final String ALGORITHM_MAC = "MAC";
    private static final ThreadLocalCryptoMap<ThreadLocalMac> MAC = new ThreadLocalCryptoMap<ThreadLocalMac>(new ThreadLocalCryptoMap.Factory<ThreadLocalMac>(){

        @Override
        public ThreadLocalMac getInstance(String algorithm) {
            return new ThreadLocalMac(algorithm);
        }
    });
    private final PskPublicInformation pskIdentity;
    private final SecretKey secret;
    private final boolean masterSecret;
    private final boolean destroy;

    public PskSecretResult(ConnectionId cid, PskPublicInformation pskIdentity, SecretKey secret, boolean masterSecret, boolean destroy) {
        this(cid, pskIdentity, secret, null, masterSecret, destroy);
    }

    public PskSecretResult(ConnectionId cid, PskPublicInformation pskIdentity, SecretKey secret, Object customArgument, boolean masterSecret, boolean destroy) {
        super(cid, customArgument);
        if (pskIdentity == null) {
            throw new NullPointerException("PSK identity must not be null!");
        }
        if (secret == null && customArgument != null) {
            throw new IllegalArgumentException("Custom argument must be null, if no secret is provided!");
        }
        this.pskIdentity = pskIdentity;
        this.secret = secret;
        this.masterSecret = masterSecret && secret != null;
        this.destroy = destroy && secret != null;
    }

    public PskSecretResult(ConnectionId cid, PskPublicInformation pskIdentity) {
        this(cid, pskIdentity, null, null, false, false);
    }

    public PskPublicInformation getPskPublicInformation() {
        return this.pskIdentity;
    }

    public boolean isMasterSecret() {
        return this.masterSecret;
    }

    public boolean isPskSecret() {
        return !this.masterSecret && this.secret != null;
    }

    public SecretKey getSecret() {
        return this.secret;
    }

    public SecretKey generateMasterSecret(String hmacAlgorithm, SecretKey otherSecret, byte[] seed, boolean useExtendedMasterSecret) {
        if (this.masterSecret) {
            throw new IllegalStateException("Secret is already master secret!");
        }
        return PskSecretResult.generateMasterSecret(hmacAlgorithm, this.secret, otherSecret, seed, useExtendedMasterSecret);
    }

    public SecretKey generateMasterSecret(Mac hmac, SecretKey otherSecret, byte[] seed, boolean useExtendedMasterSecret) {
        if (this.masterSecret) {
            throw new IllegalStateException("Secret is already master secret!");
        }
        return PskSecretResult.generateMasterSecret(hmac, this.secret, otherSecret, seed, useExtendedMasterSecret);
    }

    @Override
    public void destroy() throws DestroyFailedException {
        if (this.destroy) {
            SecretUtil.destroy(this.secret);
        }
    }

    @Override
    public boolean isDestroyed() {
        return SecretUtil.isDestroyed(this.secret);
    }

    public static SecretKey generateMasterSecret(String hmacAlgorithm, SecretKey pskSecret, SecretKey otherSecret, byte[] seed, boolean useExtendedMasterSecret) {
        return PskSecretResult.generateMasterSecret((Mac)MAC.get(hmacAlgorithm).current(), pskSecret, otherSecret, seed, useExtendedMasterSecret);
    }

    public static SecretKey generateMasterSecret(Mac hmac, SecretKey pskSecret, SecretKey otherSecret, byte[] seed, boolean useExtendedMasterSecret) {
        SecretKey premasterSecret = PseudoRandomFunction.generatePremasterSecretFromPSK(otherSecret, pskSecret);
        SecretKey masterSecret = PseudoRandomFunction.generateMasterSecret(hmac, premasterSecret, seed, useExtendedMasterSecret);
        SecretUtil.destroy(premasterSecret);
        return masterSecret;
    }
}

